/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ServiceEndpointPolicyDefinitionInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ServiceEndpointPolicyPropertiesFormat
implements JsonSerializable<ServiceEndpointPolicyPropertiesFormat> {
    private List<ServiceEndpointPolicyDefinitionInner> serviceEndpointPolicyDefinitions;
    private List<SubnetInner> subnets;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private String serviceAlias;
    private List<String> contextualServiceEndpointPolicies;

    public List<ServiceEndpointPolicyDefinitionInner> serviceEndpointPolicyDefinitions() {
        return this.serviceEndpointPolicyDefinitions;
    }

    public ServiceEndpointPolicyPropertiesFormat withServiceEndpointPolicyDefinitions(List<ServiceEndpointPolicyDefinitionInner> serviceEndpointPolicyDefinitions) {
        this.serviceEndpointPolicyDefinitions = serviceEndpointPolicyDefinitions;
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String serviceAlias() {
        return this.serviceAlias;
    }

    public ServiceEndpointPolicyPropertiesFormat withServiceAlias(String serviceAlias) {
        this.serviceAlias = serviceAlias;
        return this;
    }

    public List<String> contextualServiceEndpointPolicies() {
        return this.contextualServiceEndpointPolicies;
    }

    public ServiceEndpointPolicyPropertiesFormat withContextualServiceEndpointPolicies(List<String> contextualServiceEndpointPolicies) {
        this.contextualServiceEndpointPolicies = contextualServiceEndpointPolicies;
        return this;
    }

    public void validate() {
        if (this.serviceEndpointPolicyDefinitions() != null) {
            this.serviceEndpointPolicyDefinitions().forEach(e -> e.validate());
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("serviceEndpointPolicyDefinitions", this.serviceEndpointPolicyDefinitions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("serviceAlias", this.serviceAlias);
        jsonWriter.writeArrayField("contextualServiceEndpointPolicies", this.contextualServiceEndpointPolicies, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ServiceEndpointPolicyPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceEndpointPolicyPropertiesFormat)jsonReader.readObject(reader -> {
            ServiceEndpointPolicyPropertiesFormat deserializedServiceEndpointPolicyPropertiesFormat = new ServiceEndpointPolicyPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceEndpointPolicyDefinitions".equals(fieldName)) {
                    List serviceEndpointPolicyDefinitions;
                    deserializedServiceEndpointPolicyPropertiesFormat.serviceEndpointPolicyDefinitions = serviceEndpointPolicyDefinitions = reader.readArray(reader1 -> ServiceEndpointPolicyDefinitionInner.fromJson(reader1));
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List subnets;
                    deserializedServiceEndpointPolicyPropertiesFormat.subnets = subnets = reader.readArray(reader1 -> SubnetInner.fromJson(reader1));
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedServiceEndpointPolicyPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedServiceEndpointPolicyPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("serviceAlias".equals(fieldName)) {
                    deserializedServiceEndpointPolicyPropertiesFormat.serviceAlias = reader.getString();
                    continue;
                }
                if ("contextualServiceEndpointPolicies".equals(fieldName)) {
                    List contextualServiceEndpointPolicies;
                    deserializedServiceEndpointPolicyPropertiesFormat.contextualServiceEndpointPolicies = contextualServiceEndpointPolicies = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceEndpointPolicyPropertiesFormat;
        });
    }
}

