/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class NextHopParameters
implements JsonSerializable<NextHopParameters> {
    private String targetResourceId;
    private String sourceIpAddress;
    private String destinationIpAddress;
    private String targetNicResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(NextHopParameters.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public NextHopParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String sourceIpAddress() {
        return this.sourceIpAddress;
    }

    public NextHopParameters withSourceIpAddress(String sourceIpAddress) {
        this.sourceIpAddress = sourceIpAddress;
        return this;
    }

    public String destinationIpAddress() {
        return this.destinationIpAddress;
    }

    public NextHopParameters withDestinationIpAddress(String destinationIpAddress) {
        this.destinationIpAddress = destinationIpAddress;
        return this;
    }

    public String targetNicResourceId() {
        return this.targetNicResourceId;
    }

    public NextHopParameters withTargetNicResourceId(String targetNicResourceId) {
        this.targetNicResourceId = targetNicResourceId;
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model NextHopParameters"));
        }
        if (this.sourceIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceIpAddress in model NextHopParameters"));
        }
        if (this.destinationIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationIpAddress in model NextHopParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("sourceIPAddress", this.sourceIpAddress);
        jsonWriter.writeStringField("destinationIPAddress", this.destinationIpAddress);
        jsonWriter.writeStringField("targetNicResourceId", this.targetNicResourceId);
        return jsonWriter.writeEndObject();
    }

    public static NextHopParameters fromJson(JsonReader jsonReader) throws IOException {
        return (NextHopParameters)jsonReader.readObject(reader -> {
            NextHopParameters deserializedNextHopParameters = new NextHopParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedNextHopParameters.targetResourceId = reader.getString();
                    continue;
                }
                if ("sourceIPAddress".equals(fieldName)) {
                    deserializedNextHopParameters.sourceIpAddress = reader.getString();
                    continue;
                }
                if ("destinationIPAddress".equals(fieldName)) {
                    deserializedNextHopParameters.destinationIpAddress = reader.getString();
                    continue;
                }
                if ("targetNicResourceId".equals(fieldName)) {
                    deserializedNextHopParameters.targetNicResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNextHopParameters;
        });
    }
}

