/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DnsSettings
implements JsonSerializable<DnsSettings> {
    private List<String> servers;
    private Boolean enableProxy;
    private Boolean requireProxyForNetworkRules;

    public List<String> servers() {
        return this.servers;
    }

    public DnsSettings withServers(List<String> servers) {
        this.servers = servers;
        return this;
    }

    public Boolean enableProxy() {
        return this.enableProxy;
    }

    public DnsSettings withEnableProxy(Boolean enableProxy) {
        this.enableProxy = enableProxy;
        return this;
    }

    public Boolean requireProxyForNetworkRules() {
        return this.requireProxyForNetworkRules;
    }

    public DnsSettings withRequireProxyForNetworkRules(Boolean requireProxyForNetworkRules) {
        this.requireProxyForNetworkRules = requireProxyForNetworkRules;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("servers", this.servers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enableProxy", this.enableProxy);
        jsonWriter.writeBooleanField("requireProxyForNetworkRules", this.requireProxyForNetworkRules);
        return jsonWriter.writeEndObject();
    }

    public static DnsSettings fromJson(JsonReader jsonReader) throws IOException {
        return (DnsSettings)jsonReader.readObject(reader -> {
            DnsSettings deserializedDnsSettings = new DnsSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("servers".equals(fieldName)) {
                    List servers;
                    deserializedDnsSettings.servers = servers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("enableProxy".equals(fieldName)) {
                    deserializedDnsSettings.enableProxy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requireProxyForNetworkRules".equals(fieldName)) {
                    deserializedDnsSettings.requireProxyForNetworkRules = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsSettings;
        });
    }
}

