/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityUserGroupItem;
import java.io.IOException;
import java.util.List;

public final class SecurityUserRuleCollectionPropertiesFormat
implements JsonSerializable<SecurityUserRuleCollectionPropertiesFormat> {
    private String description;
    private List<SecurityUserGroupItem> appliesToGroups;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityUserRuleCollectionPropertiesFormat.class);

    public String description() {
        return this.description;
    }

    public SecurityUserRuleCollectionPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<SecurityUserGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    public SecurityUserRuleCollectionPropertiesFormat withAppliesToGroups(List<SecurityUserGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.appliesToGroups() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appliesToGroups in model SecurityUserRuleCollectionPropertiesFormat"));
        }
        this.appliesToGroups().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("appliesToGroups", this.appliesToGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static SecurityUserRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityUserRuleCollectionPropertiesFormat)jsonReader.readObject(reader -> {
            SecurityUserRuleCollectionPropertiesFormat deserializedSecurityUserRuleCollectionPropertiesFormat = new SecurityUserRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appliesToGroups".equals(fieldName)) {
                    List appliesToGroups;
                    deserializedSecurityUserRuleCollectionPropertiesFormat.appliesToGroups = appliesToGroups = reader.readArray(reader1 -> SecurityUserGroupItem.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionPropertiesFormat.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityUserRuleCollectionPropertiesFormat;
        });
    }
}

