/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpConfigurationBgpPeeringAddress;
import java.io.IOException;
import java.util.List;

public final class BgpSettings
implements JsonSerializable<BgpSettings> {
    private Long asn;
    private String bgpPeeringAddress;
    private Integer peerWeight;
    private List<IpConfigurationBgpPeeringAddress> bgpPeeringAddresses;

    public Long asn() {
        return this.asn;
    }

    public BgpSettings withAsn(Long asn) {
        this.asn = asn;
        return this;
    }

    public String bgpPeeringAddress() {
        return this.bgpPeeringAddress;
    }

    public BgpSettings withBgpPeeringAddress(String bgpPeeringAddress) {
        this.bgpPeeringAddress = bgpPeeringAddress;
        return this;
    }

    public Integer peerWeight() {
        return this.peerWeight;
    }

    public BgpSettings withPeerWeight(Integer peerWeight) {
        this.peerWeight = peerWeight;
        return this;
    }

    public List<IpConfigurationBgpPeeringAddress> bgpPeeringAddresses() {
        return this.bgpPeeringAddresses;
    }

    public BgpSettings withBgpPeeringAddresses(List<IpConfigurationBgpPeeringAddress> bgpPeeringAddresses) {
        this.bgpPeeringAddresses = bgpPeeringAddresses;
        return this;
    }

    public void validate() {
        if (this.bgpPeeringAddresses() != null) {
            this.bgpPeeringAddresses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("asn", (Number)this.asn);
        jsonWriter.writeStringField("bgpPeeringAddress", this.bgpPeeringAddress);
        jsonWriter.writeNumberField("peerWeight", (Number)this.peerWeight);
        jsonWriter.writeArrayField("bgpPeeringAddresses", this.bgpPeeringAddresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BgpSettings fromJson(JsonReader jsonReader) throws IOException {
        return (BgpSettings)jsonReader.readObject(reader -> {
            BgpSettings deserializedBgpSettings = new BgpSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("asn".equals(fieldName)) {
                    deserializedBgpSettings.asn = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("bgpPeeringAddress".equals(fieldName)) {
                    deserializedBgpSettings.bgpPeeringAddress = reader.getString();
                    continue;
                }
                if ("peerWeight".equals(fieldName)) {
                    deserializedBgpSettings.peerWeight = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("bgpPeeringAddresses".equals(fieldName)) {
                    List bgpPeeringAddresses;
                    deserializedBgpSettings.bgpPeeringAddresses = bgpPeeringAddresses = reader.readArray(reader1 -> IpConfigurationBgpPeeringAddress.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpSettings;
        });
    }
}

