/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ScopeConnectionsClient;
import com.azure.resourcemanager.network.fluent.models.ScopeConnectionInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ScopeConnectionListResult;
import reactor.core.publisher.Mono;

public final class ScopeConnectionsClientImpl
implements ScopeConnectionsClient {
    private final ScopeConnectionsService service;
    private final NetworkManagementClientImpl client;

    ScopeConnectionsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ScopeConnectionsService)RestProxy.create(ScopeConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ScopeConnectionInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName, ScopeConnectionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (scopeConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeConnectionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, scopeConnectionName, "2024-05-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScopeConnectionInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName, ScopeConnectionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (scopeConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeConnectionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, scopeConnectionName, "2024-05-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ScopeConnectionInner> createOrUpdateAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName, ScopeConnectionInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, networkManagerName, scopeConnectionName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ScopeConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScopeConnectionInner> createOrUpdateWithResponse(String resourceGroupName, String networkManagerName, String scopeConnectionName, ScopeConnectionInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, networkManagerName, scopeConnectionName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScopeConnectionInner createOrUpdate(String resourceGroupName, String networkManagerName, String scopeConnectionName, ScopeConnectionInner parameters) {
        return (ScopeConnectionInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, networkManagerName, scopeConnectionName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ScopeConnectionInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (scopeConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeConnectionName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, scopeConnectionName, "2024-05-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScopeConnectionInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (scopeConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeConnectionName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, scopeConnectionName, "2024-05-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ScopeConnectionInner> getAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, scopeConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ScopeConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScopeConnectionInner> getWithResponse(String resourceGroupName, String networkManagerName, String scopeConnectionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkManagerName, scopeConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScopeConnectionInner get(String resourceGroupName, String networkManagerName, String scopeConnectionName) {
        return (ScopeConnectionInner)((Object)this.getWithResponse(resourceGroupName, networkManagerName, scopeConnectionName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (scopeConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeConnectionName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, scopeConnectionName, "2024-05-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (scopeConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeConnectionName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, scopeConnectionName, "2024-05-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String scopeConnectionName) {
        return this.deleteWithResponseAsync(resourceGroupName, networkManagerName, scopeConnectionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String networkManagerName, String scopeConnectionName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, networkManagerName, scopeConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String scopeConnectionName) {
        this.deleteWithResponse(resourceGroupName, networkManagerName, scopeConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeConnectionInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, "2024-05-01", top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeConnectionListResult)res.getValue()).value(), ((ScopeConnectionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeConnectionInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, "2024-05-01", top, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeConnectionListResult)res.getValue()).value(), ((ScopeConnectionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ScopeConnectionInner> listAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ScopeConnectionInner> listAsync(String resourceGroupName, String networkManagerName) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ScopeConnectionInner> listAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ScopeConnectionInner> list(String resourceGroupName, String networkManagerName) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, top, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ScopeConnectionInner> list(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, top, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeConnectionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeConnectionListResult)res.getValue()).value(), ((ScopeConnectionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScopeConnectionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScopeConnectionListResult)res.getValue()).value(), ((ScopeConnectionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface ScopeConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/scopeConnections/{scopeConnectionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScopeConnectionInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @PathParam(value="scopeConnectionName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ScopeConnectionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/scopeConnections/{scopeConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScopeConnectionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @PathParam(value="scopeConnectionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/scopeConnections/{scopeConnectionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @PathParam(value="scopeConnectionName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/scopeConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScopeConnectionListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScopeConnectionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

