/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.PrivateEndpointIpConfiguration;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class PrivateEndpointPropertiesInner
implements JsonSerializable<PrivateEndpointPropertiesInner> {
    private SubnetInner subnet;
    private List<NetworkInterfaceInner> networkInterfaces;
    private ProvisioningState provisioningState;
    private List<PrivateLinkServiceConnection> privateLinkServiceConnections;
    private List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections;
    private List<CustomDnsConfigPropertiesFormat> customDnsConfigs;
    private List<ApplicationSecurityGroupInner> applicationSecurityGroups;
    private List<PrivateEndpointIpConfiguration> ipConfigurations;
    private String customNetworkInterfaceName;

    public SubnetInner subnet() {
        return this.subnet;
    }

    public PrivateEndpointPropertiesInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<PrivateLinkServiceConnection> privateLinkServiceConnections() {
        return this.privateLinkServiceConnections;
    }

    public PrivateEndpointPropertiesInner withPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> privateLinkServiceConnections) {
        this.privateLinkServiceConnections = privateLinkServiceConnections;
        return this;
    }

    public List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections() {
        return this.manualPrivateLinkServiceConnections;
    }

    public PrivateEndpointPropertiesInner withManualPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections) {
        this.manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections;
        return this;
    }

    public List<CustomDnsConfigPropertiesFormat> customDnsConfigs() {
        return this.customDnsConfigs;
    }

    public PrivateEndpointPropertiesInner withCustomDnsConfigs(List<CustomDnsConfigPropertiesFormat> customDnsConfigs) {
        this.customDnsConfigs = customDnsConfigs;
        return this;
    }

    public List<ApplicationSecurityGroupInner> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public PrivateEndpointPropertiesInner withApplicationSecurityGroups(List<ApplicationSecurityGroupInner> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    public List<PrivateEndpointIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public PrivateEndpointPropertiesInner withIpConfigurations(List<PrivateEndpointIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public String customNetworkInterfaceName() {
        return this.customNetworkInterfaceName;
    }

    public PrivateEndpointPropertiesInner withCustomNetworkInterfaceName(String customNetworkInterfaceName) {
        this.customNetworkInterfaceName = customNetworkInterfaceName;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.privateLinkServiceConnections() != null) {
            this.privateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (this.manualPrivateLinkServiceConnections() != null) {
            this.manualPrivateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (this.customDnsConfigs() != null) {
            this.customDnsConfigs().forEach(e -> e.validate());
        }
        if (this.applicationSecurityGroups() != null) {
            this.applicationSecurityGroups().forEach(e -> e.validate());
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeArrayField("privateLinkServiceConnections", this.privateLinkServiceConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("manualPrivateLinkServiceConnections", this.manualPrivateLinkServiceConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("customDnsConfigs", this.customDnsConfigs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("applicationSecurityGroups", this.applicationSecurityGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("customNetworkInterfaceName", this.customNetworkInterfaceName);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointPropertiesInner)jsonReader.readObject(reader -> {
            PrivateEndpointPropertiesInner deserializedPrivateEndpointPropertiesInner = new PrivateEndpointPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedPrivateEndpointPropertiesInner.subnet = SubnetInner.fromJson(reader);
                    continue;
                }
                if ("networkInterfaces".equals(fieldName)) {
                    List networkInterfaces;
                    deserializedPrivateEndpointPropertiesInner.networkInterfaces = networkInterfaces = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateEndpointPropertiesInner.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkServiceConnections".equals(fieldName)) {
                    List privateLinkServiceConnections;
                    deserializedPrivateEndpointPropertiesInner.privateLinkServiceConnections = privateLinkServiceConnections = reader.readArray(reader1 -> PrivateLinkServiceConnection.fromJson(reader1));
                    continue;
                }
                if ("manualPrivateLinkServiceConnections".equals(fieldName)) {
                    List manualPrivateLinkServiceConnections;
                    deserializedPrivateEndpointPropertiesInner.manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections = reader.readArray(reader1 -> PrivateLinkServiceConnection.fromJson(reader1));
                    continue;
                }
                if ("customDnsConfigs".equals(fieldName)) {
                    List customDnsConfigs;
                    deserializedPrivateEndpointPropertiesInner.customDnsConfigs = customDnsConfigs = reader.readArray(reader1 -> CustomDnsConfigPropertiesFormat.fromJson(reader1));
                    continue;
                }
                if ("applicationSecurityGroups".equals(fieldName)) {
                    List applicationSecurityGroups;
                    deserializedPrivateEndpointPropertiesInner.applicationSecurityGroups = applicationSecurityGroups = reader.readArray(reader1 -> ApplicationSecurityGroupInner.fromJson(reader1));
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedPrivateEndpointPropertiesInner.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> PrivateEndpointIpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("customNetworkInterfaceName".equals(fieldName)) {
                    deserializedPrivateEndpointPropertiesInner.customNetworkInterfaceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointPropertiesInner;
        });
    }
}

