/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.LoadBalancerBackendAddressAdminState;
import com.azure.resourcemanager.network.models.NatRulePortMapping;
import java.io.IOException;
import java.util.List;

public final class LoadBalancerBackendAddressPropertiesFormat
implements JsonSerializable<LoadBalancerBackendAddressPropertiesFormat> {
    private SubResource virtualNetwork;
    private SubResource subnet;
    private String ipAddress;
    private SubResource networkInterfaceIpConfiguration;
    private SubResource loadBalancerFrontendIpConfiguration;
    private List<NatRulePortMapping> inboundNatRulesPortMapping;
    private LoadBalancerBackendAddressAdminState adminState;

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public LoadBalancerBackendAddressPropertiesFormat withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public SubResource subnet() {
        return this.subnet;
    }

    public LoadBalancerBackendAddressPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public LoadBalancerBackendAddressPropertiesFormat withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public SubResource networkInterfaceIpConfiguration() {
        return this.networkInterfaceIpConfiguration;
    }

    public SubResource loadBalancerFrontendIpConfiguration() {
        return this.loadBalancerFrontendIpConfiguration;
    }

    public LoadBalancerBackendAddressPropertiesFormat withLoadBalancerFrontendIpConfiguration(SubResource loadBalancerFrontendIpConfiguration) {
        this.loadBalancerFrontendIpConfiguration = loadBalancerFrontendIpConfiguration;
        return this;
    }

    public List<NatRulePortMapping> inboundNatRulesPortMapping() {
        return this.inboundNatRulesPortMapping;
    }

    public LoadBalancerBackendAddressAdminState adminState() {
        return this.adminState;
    }

    public LoadBalancerBackendAddressPropertiesFormat withAdminState(LoadBalancerBackendAddressAdminState adminState) {
        this.adminState = adminState;
        return this;
    }

    public void validate() {
        if (this.inboundNatRulesPortMapping() != null) {
            this.inboundNatRulesPortMapping().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetwork", (JsonSerializable)this.virtualNetwork);
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeJsonField("loadBalancerFrontendIPConfiguration", (JsonSerializable)this.loadBalancerFrontendIpConfiguration);
        jsonWriter.writeStringField("adminState", this.adminState == null ? null : this.adminState.toString());
        return jsonWriter.writeEndObject();
    }

    public static LoadBalancerBackendAddressPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (LoadBalancerBackendAddressPropertiesFormat)jsonReader.readObject(reader -> {
            LoadBalancerBackendAddressPropertiesFormat deserializedLoadBalancerBackendAddressPropertiesFormat = new LoadBalancerBackendAddressPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.virtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.subnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.ipAddress = reader.getString();
                    continue;
                }
                if ("networkInterfaceIPConfiguration".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.networkInterfaceIpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("loadBalancerFrontendIPConfiguration".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.loadBalancerFrontendIpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("inboundNatRulesPortMapping".equals(fieldName)) {
                    List inboundNatRulesPortMapping;
                    deserializedLoadBalancerBackendAddressPropertiesFormat.inboundNatRulesPortMapping = inboundNatRulesPortMapping = reader.readArray(reader1 -> NatRulePortMapping.fromJson(reader1));
                    continue;
                }
                if ("adminState".equals(fieldName)) {
                    deserializedLoadBalancerBackendAddressPropertiesFormat.adminState = LoadBalancerBackendAddressAdminState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadBalancerBackendAddressPropertiesFormat;
        });
    }
}

