/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointPropertiesInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.PrivateEndpointIpConfiguration;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class PrivateEndpointInner
extends Resource {
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties")
    private PrivateEndpointPropertiesInner innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public PrivateEndpointInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private PrivateEndpointPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public PrivateEndpointInner withId(String id) {
        this.id = id;
        return this;
    }

    public PrivateEndpointInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PrivateEndpointInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubnetInner subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public PrivateEndpointInner withSubnet(SubnetInner subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaces();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<PrivateLinkServiceConnection> privateLinkServiceConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnections();
    }

    public PrivateEndpointInner withPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> privateLinkServiceConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withPrivateLinkServiceConnections(privateLinkServiceConnections);
        return this;
    }

    public List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().manualPrivateLinkServiceConnections();
    }

    public PrivateEndpointInner withManualPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withManualPrivateLinkServiceConnections(manualPrivateLinkServiceConnections);
        return this;
    }

    public List<CustomDnsConfigPropertiesFormat> customDnsConfigs() {
        return this.innerProperties() == null ? null : this.innerProperties().customDnsConfigs();
    }

    public PrivateEndpointInner withCustomDnsConfigs(List<CustomDnsConfigPropertiesFormat> customDnsConfigs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withCustomDnsConfigs(customDnsConfigs);
        return this;
    }

    public List<ApplicationSecurityGroupInner> applicationSecurityGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationSecurityGroups();
    }

    public PrivateEndpointInner withApplicationSecurityGroups(List<ApplicationSecurityGroupInner> applicationSecurityGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withApplicationSecurityGroups(applicationSecurityGroups);
        return this;
    }

    public List<PrivateEndpointIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public PrivateEndpointInner withIpConfigurations(List<PrivateEndpointIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public String customNetworkInterfaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().customNetworkInterfaceName();
    }

    public PrivateEndpointInner withCustomNetworkInterfaceName(String customNetworkInterfaceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointPropertiesInner();
        }
        this.innerProperties().withCustomNetworkInterfaceName(customNetworkInterfaceName);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

