/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationProfileInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ContainerNetworkInterfaceConfiguration
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerNetworkInterfaceConfiguration.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.ipConfigurations")
    private List<IpConfigurationProfileInner> ipConfigurations;
    @JsonProperty(value="properties.containerNetworkInterfaces")
    private List<SubResource> containerNetworkInterfaces;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public ContainerNetworkInterfaceConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public List<IpConfigurationProfileInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public ContainerNetworkInterfaceConfiguration withIpConfigurations(List<IpConfigurationProfileInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public List<SubResource> containerNetworkInterfaces() {
        return this.containerNetworkInterfaces;
    }

    public ContainerNetworkInterfaceConfiguration withContainerNetworkInterfaces(List<SubResource> containerNetworkInterfaces) {
        this.containerNetworkInterfaces = containerNetworkInterfaces;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ContainerNetworkInterfaceConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }
}

