/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectionMonitorHttpConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorIcmpConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorSuccessThreshold;
import com.azure.resourcemanager.network.models.ConnectionMonitorTcpConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfigurationProtocol;
import com.azure.resourcemanager.network.models.PreferredIpVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ConnectionMonitorTestConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ConnectionMonitorTestConfiguration.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="testFrequencySec")
    private Integer testFrequencySec;
    @JsonProperty(value="protocol", required=true)
    private ConnectionMonitorTestConfigurationProtocol protocol;
    @JsonProperty(value="preferredIPVersion")
    private PreferredIpVersion preferredIpVersion;
    @JsonProperty(value="httpConfiguration")
    private ConnectionMonitorHttpConfiguration httpConfiguration;
    @JsonProperty(value="tcpConfiguration")
    private ConnectionMonitorTcpConfiguration tcpConfiguration;
    @JsonProperty(value="icmpConfiguration")
    private ConnectionMonitorIcmpConfiguration icmpConfiguration;
    @JsonProperty(value="successThreshold")
    private ConnectionMonitorSuccessThreshold successThreshold;

    public String name() {
        return this.name;
    }

    public ConnectionMonitorTestConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public Integer testFrequencySec() {
        return this.testFrequencySec;
    }

    public ConnectionMonitorTestConfiguration withTestFrequencySec(Integer testFrequencySec) {
        this.testFrequencySec = testFrequencySec;
        return this;
    }

    public ConnectionMonitorTestConfigurationProtocol protocol() {
        return this.protocol;
    }

    public ConnectionMonitorTestConfiguration withProtocol(ConnectionMonitorTestConfigurationProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public PreferredIpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    public ConnectionMonitorTestConfiguration withPreferredIpVersion(PreferredIpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    public ConnectionMonitorHttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    public ConnectionMonitorTestConfiguration withHttpConfiguration(ConnectionMonitorHttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
        return this;
    }

    public ConnectionMonitorTcpConfiguration tcpConfiguration() {
        return this.tcpConfiguration;
    }

    public ConnectionMonitorTestConfiguration withTcpConfiguration(ConnectionMonitorTcpConfiguration tcpConfiguration) {
        this.tcpConfiguration = tcpConfiguration;
        return this;
    }

    public ConnectionMonitorIcmpConfiguration icmpConfiguration() {
        return this.icmpConfiguration;
    }

    public ConnectionMonitorTestConfiguration withIcmpConfiguration(ConnectionMonitorIcmpConfiguration icmpConfiguration) {
        this.icmpConfiguration = icmpConfiguration;
        return this;
    }

    public ConnectionMonitorSuccessThreshold successThreshold() {
        return this.successThreshold;
    }

    public ConnectionMonitorTestConfiguration withSuccessThreshold(ConnectionMonitorSuccessThreshold successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ConnectionMonitorTestConfiguration"));
        }
        if (this.protocol() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property protocol in model ConnectionMonitorTestConfiguration"));
        }
        if (this.httpConfiguration() != null) {
            this.httpConfiguration().validate();
        }
        if (this.tcpConfiguration() != null) {
            this.tcpConfiguration().validate();
        }
        if (this.icmpConfiguration() != null) {
            this.icmpConfiguration().validate();
        }
        if (this.successThreshold() != null) {
            this.successThreshold().validate();
        }
    }
}

