/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class BastionHostIpConfiguration
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BastionHostIpConfiguration.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.subnet")
    private SubResource subnet;
    @JsonProperty(value="properties.publicIPAddress")
    private SubResource publicIpAddress;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.privateIPAllocationMethod")
    private IpAllocationMethod privateIpAllocationMethod;

    public String name() {
        return this.name;
    }

    public BastionHostIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public SubResource subnet() {
        return this.subnet;
    }

    public BastionHostIpConfiguration withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    public BastionHostIpConfiguration withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public BastionHostIpConfiguration withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public BastionHostIpConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
    }
}

