/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ServiceTagsClient;
import com.azure.resourcemanager.network.fluent.models.ServiceTagsListResultInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import reactor.core.publisher.Mono;

public final class ServiceTagsClientImpl
implements ServiceTagsClient {
    private final ClientLogger logger = new ClientLogger(ServiceTagsClientImpl.class);
    private final ServiceTagsService service;
    private final NetworkManagementClientImpl client;

    ServiceTagsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ServiceTagsService)RestProxy.create(ServiceTagsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ServiceTagsListResultInner>> listWithResponseAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), location, "2020-08-01", this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ServiceTagsListResultInner>> listWithResponseAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), location, "2020-08-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    public Mono<ServiceTagsListResultInner> listAsync(String location) {
        return this.listWithResponseAsync(location).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ServiceTagsListResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ServiceTagsListResultInner list(String location) {
        return (ServiceTagsListResultInner)this.listAsync(location).block();
    }

    @Override
    public Response<ServiceTagsListResultInner> listWithResponse(String location, Context context) {
        return (Response)this.listWithResponseAsync(location, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface ServiceTagsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/serviceTags")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServiceTagsListResultInner>> list(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

