/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.management.provider.IdentifierProvider;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.implementation.NicIpConfigurationImpl;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class NetworkInterfaceImpl
extends GroupableParentResourceWithTagsImpl<NetworkInterface, NetworkInterfaceInner, NetworkInterfaceImpl, NetworkManager>
implements NetworkInterface,
NetworkInterface.Definition,
NetworkInterface.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final String nicName;
    protected final IdentifierProvider namer;
    private Map<String, NicIpConfiguration> nicIPConfigurations;
    private String creatableNetworkSecurityGroupKey;
    private NetworkSecurityGroup existingNetworkSecurityGroupToAssociate;
    private NetworkSecurityGroup networkSecurityGroup;

    NetworkInterfaceImpl(String name, NetworkInterfaceInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
        this.nicName = name;
        this.namer = ((NetworkManager)this.manager()).resourceManager().internalContext().createIdentifierProvider(this.nicName);
        this.initializeChildrenFromInner();
    }

    public Mono<NetworkInterface> refreshAsync() {
        return super.refreshAsync().map(networkInterface -> {
            NetworkInterfaceImpl impl = (NetworkInterfaceImpl)networkInterface;
            impl.clearCachedRelatedResources();
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<NetworkInterfaceInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    protected Mono<NetworkInterfaceInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().updateTagsAsync(this.resourceGroupName(), this.name(), ((NetworkInterfaceInner)((Object)this.innerModel())).tags());
    }

    @Override
    public NetworkInterfaceImpl withAcceleratedNetworking() {
        ((NetworkInterfaceInner)((Object)this.innerModel())).withEnableAcceleratedNetworking(true);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutAcceleratedNetworking() {
        ((NetworkInterfaceInner)((Object)this.innerModel())).withEnableAcceleratedNetworking(false);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(Creatable<Network> creatable) {
        this.primaryIPConfiguration().withNewNetwork((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String name, String addressSpaceCidr) {
        this.primaryIPConfiguration().withNewNetwork(name, addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String addressSpaceCidr) {
        this.primaryIPConfiguration().withNewNetwork(addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryNetwork(Network network) {
        this.primaryIPConfiguration().withExistingNetwork(network);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress(Creatable<PublicIpAddress> creatable) {
        this.primaryIPConfiguration().withNewPublicIpAddress((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress() {
        this.primaryIPConfiguration().withNewPublicIpAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress(String leafDnsLabel) {
        this.primaryIPConfiguration().withNewPublicIpAddress(leafDnsLabel);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerBackend(LoadBalancer loadBalancer, String backendName) {
        this.primaryIPConfiguration().withExistingLoadBalancerBackend(loadBalancer, backendName);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerInboundNatRule(LoadBalancer loadBalancer, String inboundNatRuleName) {
        this.primaryIPConfiguration().withExistingLoadBalancerInboundNatRule(loadBalancer, inboundNatRuleName);
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerBackends() {
        for (NicIpConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIPConfiguration(ipConfig.name()).withoutLoadBalancerBackends();
        }
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerInboundNatRules() {
        for (NicIpConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIPConfiguration(ipConfig.name()).withoutLoadBalancerInboundNatRules();
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutPrimaryPublicIPAddress() {
        this.primaryIPConfiguration().withoutPublicIpAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryPublicIPAddress(PublicIpAddress publicIPAddress) {
        this.primaryIPConfiguration().withExistingPublicIpAddress(publicIPAddress);
        this.primaryIPConfiguration().withPrivateIpVersion(publicIPAddress.version());
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIPAddressDynamic() {
        this.primaryIPConfiguration().withPrivateIpAddressDynamic();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIPAddressStatic(String staticPrivateIPAddress) {
        this.primaryIPConfiguration().withPrivateIpAddressStatic(staticPrivateIPAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> creatable) {
        if (this.creatableNetworkSecurityGroupKey == null) {
            this.creatableNetworkSecurityGroupKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup networkSecurityGroup) {
        this.existingNetworkSecurityGroupToAssociate = networkSecurityGroup;
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutNetworkSecurityGroup() {
        ((NetworkInterfaceInner)((Object)this.innerModel())).withNetworkSecurityGroup(null);
        return this;
    }

    public NicIpConfigurationImpl defineSecondaryIPConfiguration(String name) {
        return this.prepareNewNicIPConfiguration(name);
    }

    @Override
    public NicIpConfigurationImpl updateIPConfiguration(String name) {
        return (NicIpConfigurationImpl)this.nicIPConfigurations.get(name);
    }

    @Override
    public NetworkInterfaceImpl withIPForwarding() {
        ((NetworkInterfaceInner)((Object)this.innerModel())).withEnableIpForwarding(true);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutIPConfiguration(String name) {
        this.nicIPConfigurations.remove(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutIPForwarding() {
        ((NetworkInterfaceInner)((Object)this.innerModel())).withEnableIpForwarding(false);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withDnsServer(String ipAddress) {
        this.dnsServerIPs().add(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutDnsServer(String ipAddress) {
        this.dnsServerIPs().remove(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withAzureDnsServer() {
        this.dnsServerIPs().clear();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withSubnet(String name) {
        this.primaryIPConfiguration().withSubnet(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withInternalDnsNameLabel(String dnsNameLabel) {
        ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().withInternalDnsNameLabel(dnsNameLabel);
        return this;
    }

    @Override
    public boolean isAcceleratedNetworkingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.innerModel())).enableAcceleratedNetworking());
    }

    @Override
    public String virtualMachineId() {
        if (((NetworkInterfaceInner)((Object)this.innerModel())).virtualMachine() != null) {
            return ((NetworkInterfaceInner)((Object)this.innerModel())).virtualMachine().id();
        }
        return null;
    }

    @Override
    public boolean isIPForwardingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.innerModel())).enableIpForwarding());
    }

    @Override
    public String macAddress() {
        return ((NetworkInterfaceInner)((Object)this.innerModel())).macAddress();
    }

    @Override
    public String internalDnsNameLabel() {
        return ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().internalDnsNameLabel() : null;
    }

    @Override
    public String internalDomainNameSuffix() {
        return ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().internalDomainNameSuffix() : null;
    }

    @Override
    public List<String> appliedDnsServers() {
        ArrayList dnsServers = new ArrayList();
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().appliedDnsServers() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().appliedDnsServers());
    }

    @Override
    public String internalFqdn() {
        return ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() != null ? ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().internalFqdn() : null;
    }

    @Override
    public List<String> dnsServers() {
        return this.dnsServerIPs();
    }

    @Override
    public String primaryPrivateIP() {
        return this.primaryIPConfiguration().privateIpAddress();
    }

    @Override
    public IpAllocationMethod primaryPrivateIpAllocationMethod() {
        return this.primaryIPConfiguration().privateIpAllocationMethod();
    }

    @Override
    public Map<String, NicIpConfiguration> ipConfigurations() {
        return Collections.unmodifiableMap(this.nicIPConfigurations);
    }

    @Override
    public String networkSecurityGroupId() {
        return ((NetworkInterfaceInner)((Object)this.innerModel())).networkSecurityGroup() != null ? ((NetworkInterfaceInner)((Object)this.innerModel())).networkSecurityGroup().id() : null;
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        if (this.networkSecurityGroup == null && this.networkSecurityGroupId() != null) {
            String id = this.networkSecurityGroupId();
            this.networkSecurityGroup = (NetworkSecurityGroup)((NetworkManager)this.myManager).networkSecurityGroups().getByResourceGroup(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id));
        }
        return this.networkSecurityGroup;
    }

    @Override
    public NicIpConfigurationImpl primaryIPConfiguration() {
        NicIpConfigurationImpl primaryIPConfig = null;
        if (this.nicIPConfigurations.size() == 0) {
            primaryIPConfig = this.prepareNewNicIPConfiguration("primary");
            ((NetworkInterfaceIpConfigurationInner)((Object)primaryIPConfig.innerModel())).withPrimary(true);
            this.withIPConfiguration(primaryIPConfig);
        } else if (this.nicIPConfigurations.size() == 1) {
            primaryIPConfig = (NicIpConfigurationImpl)this.nicIPConfigurations.values().iterator().next();
        } else {
            for (NicIpConfiguration ipConfig : this.nicIPConfigurations.values()) {
                if (!ipConfig.isPrimary()) continue;
                primaryIPConfig = (NicIpConfigurationImpl)ipConfig;
                break;
            }
        }
        return primaryIPConfig;
    }

    private List<String> dnsServerIPs() {
        ArrayList<String> dnsServers = new ArrayList<String>();
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() == null) {
            return dnsServers;
        }
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().dnsServers() == null) {
            return dnsServers;
        }
        return ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().dnsServers();
    }

    protected void initializeChildrenFromInner() {
        this.nicIPConfigurations = new TreeMap<String, NicIpConfiguration>();
        List<NetworkInterfaceIpConfigurationInner> inners = ((NetworkInterfaceInner)((Object)this.innerModel())).ipConfigurations();
        if (inners != null) {
            for (NetworkInterfaceIpConfigurationInner inner : inners) {
                NicIpConfigurationImpl nicIPConfiguration = new NicIpConfigurationImpl(inner, this, (NetworkManager)this.myManager, false);
                this.nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
            }
        }
    }

    private NicIpConfigurationImpl prepareNewNicIPConfiguration(String name) {
        NicIpConfigurationImpl nicIPConfiguration = NicIpConfigurationImpl.prepareNicIPConfiguration(name, this, (NetworkManager)this.myManager);
        return nicIPConfiguration;
    }

    private void clearCachedRelatedResources() {
        this.networkSecurityGroup = null;
    }

    NetworkInterfaceImpl withIPConfiguration(NicIpConfigurationImpl nicIPConfiguration) {
        this.nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
        return this;
    }

    void addToCreatableDependencies(Creatable<? extends Resource> creatableResource) {
        this.addDependency(creatableResource);
    }

    Resource createdDependencyResource(String key) {
        return (Resource)this.taskResult(key);
    }

    Creatable<ResourceGroup> newGroup() {
        return this.creatableGroup;
    }

    @Override
    public Accepted<NetworkInterface> beginCreate() {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (NetworkInterfaceInner)((Object)((Object)this.innerModel()))).block(), inner -> new NetworkInterfaceImpl(inner.name(), (NetworkInterfaceInner)((Object)inner), (NetworkManager)this.manager()), NetworkInterfaceInner.class, () -> {
            Flux dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
            this.beforeCreating();
        }, inner -> {
            this.innerToFluentMap((IndexableRefreshableWrapperImpl)this);
            this.initializeChildrenFromInner();
            this.afterCreating();
        });
    }

    protected Mono<NetworkInterfaceInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkInterfaceInner)((Object)this.innerModel()));
    }

    protected void afterCreating() {
        this.clearCachedRelatedResources();
    }

    protected void beforeCreating() {
        NetworkSecurityGroup networkSecurityGroup = null;
        if (this.creatableNetworkSecurityGroupKey != null) {
            networkSecurityGroup = (NetworkSecurityGroup)this.taskResult(this.creatableNetworkSecurityGroupKey);
        } else if (this.existingNetworkSecurityGroupToAssociate != null) {
            networkSecurityGroup = this.existingNetworkSecurityGroupToAssociate;
        }
        if (networkSecurityGroup != null) {
            ((NetworkInterfaceInner)((Object)this.innerModel())).withNetworkSecurityGroup(new NetworkSecurityGroupInner().withId(networkSecurityGroup.id()));
        }
        NicIpConfigurationImpl.ensureConfigurations(this.nicIPConfigurations.values());
        ((NetworkInterfaceInner)((Object)this.innerModel())).withIpConfigurations(this.innersFromWrappers(this.nicIPConfigurations.values()));
    }
}

