/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.FlowLogInformationInner;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.models.FlowLogSettings;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import reactor.core.publisher.Mono;

class FlowLogSettingsImpl
extends RefreshableWrapperImpl<FlowLogInformationInner, FlowLogSettings>
implements FlowLogSettings,
FlowLogSettings.Update {
    private final NetworkWatcherImpl parent;
    private final String nsgId;

    FlowLogSettingsImpl(NetworkWatcherImpl parent, FlowLogInformationInner inner, String nsgId) {
        super((Object)inner);
        this.parent = parent;
        this.nsgId = nsgId;
    }

    public FlowLogSettings apply() {
        return (FlowLogSettings)this.applyAsync().block();
    }

    public Mono<FlowLogSettings> applyAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().setFlowLogConfigurationAsync(this.parent().resourceGroupName(), this.parent().name(), (FlowLogInformationInner)this.innerModel()).map(flowLogInformationInner -> new FlowLogSettingsImpl(this.parent, (FlowLogInformationInner)flowLogInformationInner, this.nsgId));
    }

    @Override
    public FlowLogSettings.Update withLogging() {
        ((FlowLogInformationInner)this.innerModel()).withEnabled(true);
        return this;
    }

    @Override
    public FlowLogSettings.Update withoutLogging() {
        ((FlowLogInformationInner)this.innerModel()).withEnabled(false);
        return this;
    }

    @Override
    public FlowLogSettings.Update withStorageAccount(String storageId) {
        ((FlowLogInformationInner)this.innerModel()).withStorageId(storageId);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyEnabled() {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.innerModel()).retentionPolicy().withEnabled(true);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyDisabled() {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.innerModel()).retentionPolicy().withEnabled(false);
        return this;
    }

    @Override
    public FlowLogSettings.Update withRetentionPolicyDays(int days) {
        this.ensureRetentionPolicy();
        ((FlowLogInformationInner)this.innerModel()).retentionPolicy().withDays(days);
        return this;
    }

    private void ensureRetentionPolicy() {
        if (((FlowLogInformationInner)this.innerModel()).retentionPolicy() == null) {
            ((FlowLogInformationInner)this.innerModel()).withRetentionPolicy(new RetentionPolicyParameters());
        }
    }

    public FlowLogSettings.Update update() {
        if (((FlowLogInformationInner)this.innerModel()).flowAnalyticsConfiguration() != null && ((FlowLogInformationInner)this.innerModel()).flowAnalyticsConfiguration().networkWatcherFlowAnalyticsConfiguration() == null) {
            ((FlowLogInformationInner)this.innerModel()).withFlowAnalyticsConfiguration(null);
        }
        return this;
    }

    protected Mono<FlowLogInformationInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().getFlowLogStatusAsync(this.parent().resourceGroupName(), this.parent().name(), ((FlowLogInformationInner)this.innerModel()).targetResourceId());
    }

    public NetworkWatcherImpl parent() {
        return this.parent;
    }

    public String key() {
        return null;
    }

    @Override
    public String targetResourceId() {
        return ((FlowLogInformationInner)this.innerModel()).targetResourceId();
    }

    @Override
    public String storageId() {
        return ((FlowLogInformationInner)this.innerModel()).storageId();
    }

    @Override
    public boolean enabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((FlowLogInformationInner)this.innerModel()).enabled());
    }

    @Override
    public boolean isRetentionEnabled() {
        this.ensureRetentionPolicy();
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((FlowLogInformationInner)this.innerModel()).retentionPolicy().enabled());
    }

    @Override
    public int retentionDays() {
        this.ensureRetentionPolicy();
        return ResourceManagerUtils.toPrimitiveInt((Integer)((FlowLogInformationInner)this.innerModel()).retentionPolicy().days());
    }

    @Override
    public String networkSecurityGroupId() {
        return this.nsgId;
    }
}

