/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewaySslCertificateImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayFrontend;
import com.azure.resourcemanager.network.models.ApplicationGatewayHttpListener;
import com.azure.resourcemanager.network.models.ApplicationGatewayListener;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.io.File;
import java.io.IOException;

class ApplicationGatewayListenerImpl
extends ChildResourceImpl<ApplicationGatewayHttpListener, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayListener,
ApplicationGatewayListener.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayListener.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayListener.Update {
    ApplicationGatewayListenerImpl(ApplicationGatewayHttpListener inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.networkId();
        }
        return null;
    }

    public String subnetName() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend != null) {
            return frontend.subnetName();
        }
        return null;
    }

    @Override
    public boolean requiresServerNameIndication() {
        if (((ApplicationGatewayHttpListener)((Object)this.innerModel())).requireServerNameIndication() != null) {
            return ((ApplicationGatewayHttpListener)((Object)this.innerModel())).requireServerNameIndication();
        }
        return false;
    }

    @Override
    public String hostname() {
        return ((ApplicationGatewayHttpListener)((Object)this.innerModel())).hostname();
    }

    @Override
    public String publicIpAddressId() {
        ApplicationGatewayFrontend frontend = this.frontend();
        if (frontend == null) {
            return null;
        }
        return frontend.publicIpAddressId();
    }

    @Override
    public PublicIpAddress getPublicIpAddress() {
        String pipId = this.publicIpAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIpAddress)((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIpAddresses().getById(pipId);
    }

    public String name() {
        return ((ApplicationGatewayHttpListener)((Object)this.innerModel())).name();
    }

    @Override
    public ApplicationGatewaySslCertificate sslCertificate() {
        SubResource certRef = ((ApplicationGatewayHttpListener)((Object)this.innerModel())).sslCertificate();
        if (certRef == null) {
            return null;
        }
        String name = ResourceUtils.nameFromResourceId((String)certRef.id());
        return ((ApplicationGatewayImpl)this.parent()).sslCertificates().get(name);
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayHttpListener)((Object)this.innerModel())).protocol();
    }

    @Override
    public int frontendPortNumber() {
        String name = this.frontendPortName();
        if (name == null) {
            return 0;
        }
        if (!((ApplicationGatewayImpl)this.parent()).frontendPorts().containsKey(name)) {
            return 0;
        }
        return ((ApplicationGatewayImpl)this.parent()).frontendPorts().get(name);
    }

    @Override
    public String frontendPortName() {
        if (((ApplicationGatewayHttpListener)((Object)this.innerModel())).frontendPort() != null) {
            return ResourceUtils.nameFromResourceId((String)((ApplicationGatewayHttpListener)((Object)this.innerModel())).frontendPort().id());
        }
        return null;
    }

    @Override
    public ApplicationGatewayFrontend frontend() {
        SubResource frontendInner = ((ApplicationGatewayHttpListener)((Object)this.innerModel())).frontendIpConfiguration();
        if (frontendInner == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId((String)frontendInner.id());
        return ((ApplicationGatewayImpl)this.parent()).frontends().get(frontendName);
    }

    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withHttpListener(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    private ApplicationGatewayListenerImpl withFrontend(String name) {
        SubResource frontendRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendIPConfigurations/" + name);
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withFrontendIpConfiguration(frontendRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(String name) {
        SubResource portRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/frontendPorts/" + name);
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withFrontendPort(portRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withFrontendPort(int portNumber) {
        String portName = ((ApplicationGatewayImpl)this.parent()).frontendPortNameFromNumber(portNumber);
        if (portName == null) {
            portName = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("port", 9);
            ((ApplicationGatewayImpl)this.parent()).withFrontendPort(portNumber, portName);
        }
        return this.withFrontendPort(portName);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificate(String name) {
        SubResource certRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/sslCertificates/" + name);
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withSslCertificate(certRef);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificateFromKeyVaultSecretId(String keyVaultSecretId) {
        return this.withSslCertificateFromKeyVaultSecretId(keyVaultSecretId, null);
    }

    private ApplicationGatewayListenerImpl withSslCertificateFromKeyVaultSecretId(String keyVaultSecretId, String name) {
        if (name == null) {
            name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("cert", 10);
        }
        ((ApplicationGatewayImpl)this.parent()).defineSslCertificate(name).withKeyVaultSecretId(keyVaultSecretId).attach();
        return this;
    }

    public ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile) throws IOException {
        return this.withSslCertificateFromPfxFile(pfxFile, null);
    }

    private ApplicationGatewayListenerImpl withSslCertificateFromPfxFile(File pfxFile, String name) throws IOException {
        if (name == null) {
            name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("cert", 10);
        }
        ((ApplicationGatewayImpl)this.parent()).defineSslCertificate(name).withPfxFromFile(pfxFile).attach();
        return this.withSslCertificate(name);
    }

    @Override
    public ApplicationGatewayListenerImpl withSslCertificatePassword(String password) {
        ApplicationGatewaySslCertificateImpl sslCert = (ApplicationGatewaySslCertificateImpl)this.sslCertificate();
        if (sslCert != null) {
            sslCert.withPfxPassword(password);
        }
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttp() {
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withProtocol(ApplicationGatewayProtocol.HTTP);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHttps() {
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withProtocol(ApplicationGatewayProtocol.HTTPS);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withHostname(String hostname) {
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withHostname(hostname);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withServerNameIndication() {
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withRequireServerNameIndication(true);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withoutServerNameIndication() {
        ((ApplicationGatewayHttpListener)((Object)this.innerModel())).withRequireServerNameIndication(false);
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPrivateFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPrivateFrontend().name());
        return this;
    }

    @Override
    public ApplicationGatewayListenerImpl withPublicFrontend() {
        this.withFrontend(((ApplicationGatewayImpl)this.parent()).ensureDefaultPublicFrontend().name());
        return this;
    }
}

