/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySku;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayType;
import com.azure.resourcemanager.network.models.VpnClientConfiguration;
import com.azure.resourcemanager.network.models.VpnGatewayGeneration;
import com.azure.resourcemanager.network.models.VpnType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualNetworkGatewayInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkGatewayInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.ipConfigurations")
    private List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations;
    @JsonProperty(value="properties.gatewayType")
    private VirtualNetworkGatewayType gatewayType;
    @JsonProperty(value="properties.vpnType")
    private VpnType vpnType;
    @JsonProperty(value="properties.vpnGatewayGeneration")
    private VpnGatewayGeneration vpnGatewayGeneration;
    @JsonProperty(value="properties.enableBgp")
    private Boolean enableBgp;
    @JsonProperty(value="properties.enablePrivateIpAddress")
    private Boolean enablePrivateIpAddress;
    @JsonProperty(value="properties.activeActive")
    private Boolean active;
    @JsonProperty(value="properties.gatewayDefaultSite")
    private SubResource gatewayDefaultSite;
    @JsonProperty(value="properties.sku")
    private VirtualNetworkGatewaySku sku;
    @JsonProperty(value="properties.vpnClientConfiguration")
    private VpnClientConfiguration vpnClientConfiguration;
    @JsonProperty(value="properties.bgpSettings")
    private BgpSettings bgpSettings;
    @JsonProperty(value="properties.customRoutes")
    private AddressSpace customRoutes;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.enableDnsForwarding")
    private Boolean enableDnsForwarding;
    @JsonProperty(value="properties.inboundDnsForwardingEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String inboundDnsForwardingEndpoint;
    @JsonProperty(value="properties.virtualNetworkExtendedLocationResourceId")
    private String virtualNetworkExtendedLocationResourceId;
    @JsonProperty(value="properties.extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public VirtualNetworkGatewayInner withIpConfigurations(List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public VirtualNetworkGatewayType gatewayType() {
        return this.gatewayType;
    }

    public VirtualNetworkGatewayInner withGatewayType(VirtualNetworkGatewayType gatewayType) {
        this.gatewayType = gatewayType;
        return this;
    }

    public VpnType vpnType() {
        return this.vpnType;
    }

    public VirtualNetworkGatewayInner withVpnType(VpnType vpnType) {
        this.vpnType = vpnType;
        return this;
    }

    public VpnGatewayGeneration vpnGatewayGeneration() {
        return this.vpnGatewayGeneration;
    }

    public VirtualNetworkGatewayInner withVpnGatewayGeneration(VpnGatewayGeneration vpnGatewayGeneration) {
        this.vpnGatewayGeneration = vpnGatewayGeneration;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VirtualNetworkGatewayInner withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public Boolean enablePrivateIpAddress() {
        return this.enablePrivateIpAddress;
    }

    public VirtualNetworkGatewayInner withEnablePrivateIpAddress(Boolean enablePrivateIpAddress) {
        this.enablePrivateIpAddress = enablePrivateIpAddress;
        return this;
    }

    public Boolean active() {
        return this.active;
    }

    public VirtualNetworkGatewayInner withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public SubResource gatewayDefaultSite() {
        return this.gatewayDefaultSite;
    }

    public VirtualNetworkGatewayInner withGatewayDefaultSite(SubResource gatewayDefaultSite) {
        this.gatewayDefaultSite = gatewayDefaultSite;
        return this;
    }

    public VirtualNetworkGatewaySku sku() {
        return this.sku;
    }

    public VirtualNetworkGatewayInner withSku(VirtualNetworkGatewaySku sku) {
        this.sku = sku;
        return this;
    }

    public VpnClientConfiguration vpnClientConfiguration() {
        return this.vpnClientConfiguration;
    }

    public VirtualNetworkGatewayInner withVpnClientConfiguration(VpnClientConfiguration vpnClientConfiguration) {
        this.vpnClientConfiguration = vpnClientConfiguration;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public VirtualNetworkGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public AddressSpace customRoutes() {
        return this.customRoutes;
    }

    public VirtualNetworkGatewayInner withCustomRoutes(AddressSpace customRoutes) {
        this.customRoutes = customRoutes;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean enableDnsForwarding() {
        return this.enableDnsForwarding;
    }

    public VirtualNetworkGatewayInner withEnableDnsForwarding(Boolean enableDnsForwarding) {
        this.enableDnsForwarding = enableDnsForwarding;
        return this;
    }

    public String inboundDnsForwardingEndpoint() {
        return this.inboundDnsForwardingEndpoint;
    }

    public String virtualNetworkExtendedLocationResourceId() {
        return this.virtualNetworkExtendedLocationResourceId;
    }

    public VirtualNetworkGatewayInner withVirtualNetworkExtendedLocationResourceId(String virtualNetworkExtendedLocationResourceId) {
        this.virtualNetworkExtendedLocationResourceId = virtualNetworkExtendedLocationResourceId;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualNetworkGatewayInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualNetworkGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.vpnClientConfiguration() != null) {
            this.vpnClientConfiguration().validate();
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
        if (this.customRoutes() != null) {
            this.customRoutes().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }
}

