/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.HubRoute;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class HubRouteTableInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HubRouteTableInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.routes")
    private List<HubRoute> routes;
    @JsonProperty(value="properties.labels")
    private List<String> labels;
    @JsonProperty(value="properties.associatedConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> associatedConnections;
    @JsonProperty(value="properties.propagatingConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> propagatingConnections;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public HubRouteTableInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public List<HubRoute> routes() {
        return this.routes;
    }

    public HubRouteTableInner withRoutes(List<HubRoute> routes) {
        this.routes = routes;
        return this;
    }

    public List<String> labels() {
        return this.labels;
    }

    public HubRouteTableInner withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public List<String> associatedConnections() {
        return this.associatedConnections;
    }

    public List<String> propagatingConnections() {
        return this.propagatingConnections;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HubRouteTableInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
    }
}

