/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteLinkInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRoutePortPropertiesFormat;
import com.azure.resourcemanager.network.models.ExpressRoutePortsEncapsulation;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ExpressRoutePortInner
extends Resource {
    @JsonProperty(value="properties")
    private ExpressRoutePortPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="id")
    private String id;

    private ExpressRoutePortPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ExpressRoutePortInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ExpressRoutePortInner withId(String id) {
        this.id = id;
        return this;
    }

    public ExpressRoutePortInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRoutePortInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String peeringLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocation();
    }

    public ExpressRoutePortInner withPeeringLocation(String peeringLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withPeeringLocation(peeringLocation);
        return this;
    }

    public Integer bandwidthInGbps() {
        return this.innerProperties() == null ? null : this.innerProperties().bandwidthInGbps();
    }

    public ExpressRoutePortInner withBandwidthInGbps(Integer bandwidthInGbps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withBandwidthInGbps(bandwidthInGbps);
        return this;
    }

    public Float provisionedBandwidthInGbps() {
        return this.innerProperties() == null ? null : this.innerProperties().provisionedBandwidthInGbps();
    }

    public String mtu() {
        return this.innerProperties() == null ? null : this.innerProperties().mtu();
    }

    public ExpressRoutePortsEncapsulation encapsulation() {
        return this.innerProperties() == null ? null : this.innerProperties().encapsulation();
    }

    public ExpressRoutePortInner withEncapsulation(ExpressRoutePortsEncapsulation encapsulation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withEncapsulation(encapsulation);
        return this;
    }

    public String etherType() {
        return this.innerProperties() == null ? null : this.innerProperties().etherType();
    }

    public String allocationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().allocationDate();
    }

    public List<ExpressRouteLinkInner> links() {
        return this.innerProperties() == null ? null : this.innerProperties().links();
    }

    public ExpressRoutePortInner withLinks(List<ExpressRouteLinkInner> links) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortPropertiesFormat();
        }
        this.innerProperties().withLinks(links);
        return this;
    }

    public List<SubResource> circuits() {
        return this.innerProperties() == null ? null : this.innerProperties().circuits();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

