/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.RouteFilterRulePropertiesFormat;
import com.azure.resourcemanager.network.models.Access;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteFilterRuleType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RouteFilterRuleInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RouteFilterRuleInner.class);
    @JsonProperty(value="properties")
    private RouteFilterRulePropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private RouteFilterRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public RouteFilterRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public RouteFilterRuleInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public RouteFilterRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    public Access access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    public RouteFilterRuleInner withAccess(Access access) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteFilterRulePropertiesFormat();
        }
        this.innerProperties().withAccess(access);
        return this;
    }

    public RouteFilterRuleType routeFilterRuleType() {
        return this.innerProperties() == null ? null : this.innerProperties().routeFilterRuleType();
    }

    public RouteFilterRuleInner withRouteFilterRuleType(RouteFilterRuleType routeFilterRuleType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteFilterRulePropertiesFormat();
        }
        this.innerProperties().withRouteFilterRuleType(routeFilterRuleType);
        return this;
    }

    public List<String> communities() {
        return this.innerProperties() == null ? null : this.innerProperties().communities();
    }

    public RouteFilterRuleInner withCommunities(List<String> communities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteFilterRulePropertiesFormat();
        }
        this.innerProperties().withCommunities(communities);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

