/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.AzureFirewallPropertiesFormat;
import com.azure.resourcemanager.network.models.AzureFirewallApplicationRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallIpConfiguration;
import com.azure.resourcemanager.network.models.AzureFirewallIpGroups;
import com.azure.resourcemanager.network.models.AzureFirewallNatRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallSku;
import com.azure.resourcemanager.network.models.AzureFirewallThreatIntelMode;
import com.azure.resourcemanager.network.models.HubIpAddresses;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class AzureFirewallInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureFirewallInner.class);
    @JsonProperty(value="properties")
    private AzureFirewallPropertiesFormat innerProperties;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private AzureFirewallPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public AzureFirewallInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public AzureFirewallInner withId(String id) {
        this.id = id;
        return this;
    }

    public AzureFirewallInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AzureFirewallInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<AzureFirewallApplicationRuleCollection> applicationRuleCollections() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationRuleCollections();
    }

    public AzureFirewallInner withApplicationRuleCollections(List<AzureFirewallApplicationRuleCollection> applicationRuleCollections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withApplicationRuleCollections(applicationRuleCollections);
        return this;
    }

    public List<AzureFirewallNatRuleCollection> natRuleCollections() {
        return this.innerProperties() == null ? null : this.innerProperties().natRuleCollections();
    }

    public AzureFirewallInner withNatRuleCollections(List<AzureFirewallNatRuleCollection> natRuleCollections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withNatRuleCollections(natRuleCollections);
        return this;
    }

    public List<AzureFirewallNetworkRuleCollection> networkRuleCollections() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleCollections();
    }

    public AzureFirewallInner withNetworkRuleCollections(List<AzureFirewallNetworkRuleCollection> networkRuleCollections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withNetworkRuleCollections(networkRuleCollections);
        return this;
    }

    public List<AzureFirewallIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public AzureFirewallInner withIpConfigurations(List<AzureFirewallIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public AzureFirewallIpConfiguration managementIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().managementIpConfiguration();
    }

    public AzureFirewallInner withManagementIpConfiguration(AzureFirewallIpConfiguration managementIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withManagementIpConfiguration(managementIpConfiguration);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public AzureFirewallThreatIntelMode threatIntelMode() {
        return this.innerProperties() == null ? null : this.innerProperties().threatIntelMode();
    }

    public AzureFirewallInner withThreatIntelMode(AzureFirewallThreatIntelMode threatIntelMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withThreatIntelMode(threatIntelMode);
        return this;
    }

    public SubResource virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public AzureFirewallInner withVirtualHub(SubResource virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public SubResource firewallPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().firewallPolicy();
    }

    public AzureFirewallInner withFirewallPolicy(SubResource firewallPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withFirewallPolicy(firewallPolicy);
        return this;
    }

    public HubIpAddresses hubIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().hubIpAddresses();
    }

    public AzureFirewallInner withHubIpAddresses(HubIpAddresses hubIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withHubIpAddresses(hubIpAddresses);
        return this;
    }

    public List<AzureFirewallIpGroups> ipGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().ipGroups();
    }

    public AzureFirewallSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public AzureFirewallInner withSku(AzureFirewallSku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public Map<String, String> additionalProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalProperties();
    }

    public AzureFirewallInner withAdditionalProperties(Map<String, String> additionalProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withAdditionalProperties(additionalProperties);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

