/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ApplicationGatewayCustomError;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ApplicationGatewayHttpListener
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationGatewayHttpListener.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.frontendIPConfiguration")
    private SubResource frontendIpConfiguration;
    @JsonProperty(value="properties.frontendPort")
    private SubResource frontendPort;
    @JsonProperty(value="properties.protocol")
    private ApplicationGatewayProtocol protocol;
    @JsonProperty(value="properties.hostName")
    private String hostname;
    @JsonProperty(value="properties.sslCertificate")
    private SubResource sslCertificate;
    @JsonProperty(value="properties.requireServerNameIndication")
    private Boolean requireServerNameIndication;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.customErrorConfigurations")
    private List<ApplicationGatewayCustomError> customErrorConfigurations;
    @JsonProperty(value="properties.firewallPolicy")
    private SubResource firewallPolicy;
    @JsonProperty(value="properties.hostNames")
    private List<String> hostNames;

    public String name() {
        return this.name;
    }

    public ApplicationGatewayHttpListener withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public SubResource frontendIpConfiguration() {
        return this.frontendIpConfiguration;
    }

    public ApplicationGatewayHttpListener withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        this.frontendIpConfiguration = frontendIpConfiguration;
        return this;
    }

    public SubResource frontendPort() {
        return this.frontendPort;
    }

    public ApplicationGatewayHttpListener withFrontendPort(SubResource frontendPort) {
        this.frontendPort = frontendPort;
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    public ApplicationGatewayHttpListener withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ApplicationGatewayHttpListener withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public SubResource sslCertificate() {
        return this.sslCertificate;
    }

    public ApplicationGatewayHttpListener withSslCertificate(SubResource sslCertificate) {
        this.sslCertificate = sslCertificate;
        return this;
    }

    public Boolean requireServerNameIndication() {
        return this.requireServerNameIndication;
    }

    public ApplicationGatewayHttpListener withRequireServerNameIndication(Boolean requireServerNameIndication) {
        this.requireServerNameIndication = requireServerNameIndication;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ApplicationGatewayCustomError> customErrorConfigurations() {
        return this.customErrorConfigurations;
    }

    public ApplicationGatewayHttpListener withCustomErrorConfigurations(List<ApplicationGatewayCustomError> customErrorConfigurations) {
        this.customErrorConfigurations = customErrorConfigurations;
        return this;
    }

    public SubResource firewallPolicy() {
        return this.firewallPolicy;
    }

    public ApplicationGatewayHttpListener withFirewallPolicy(SubResource firewallPolicy) {
        this.firewallPolicy = firewallPolicy;
        return this;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public ApplicationGatewayHttpListener withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public void validate() {
        if (this.customErrorConfigurations() != null) {
            this.customErrorConfigurations().forEach(e -> e.validate());
        }
    }
}

