/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayConnectionListEntityInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.implementation.PointToSiteConfigurationImpl;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayConnectionsImpl;
import com.azure.resourcemanager.network.implementation.VirtualNetworkGatewayIpConfigurationImpl;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.VirtualNetworkGateway;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnection;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnections;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayIpConfiguration;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySku;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySkuName;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySkuTier;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayType;
import com.azure.resourcemanager.network.models.VpnClientConfiguration;
import com.azure.resourcemanager.network.models.VpnClientParameters;
import com.azure.resourcemanager.network.models.VpnType;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class VirtualNetworkGatewayImpl
extends GroupableParentResourceWithTagsImpl<VirtualNetworkGateway, VirtualNetworkGatewayInner, VirtualNetworkGatewayImpl, NetworkManager>
implements VirtualNetworkGateway,
VirtualNetworkGateway.Definition,
VirtualNetworkGateway.Update {
    private static final String GATEWAY_SUBNET = "GatewaySubnet";
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private Map<String, VirtualNetworkGatewayIpConfiguration> ipConfigs;
    private VirtualNetworkGatewayConnections connections;
    private Creatable<Network> creatableNetwork;
    private Creatable<PublicIpAddress> creatablePip;

    VirtualNetworkGatewayImpl(String name, VirtualNetworkGatewayInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    public VirtualNetworkGatewayImpl withExpressRoute() {
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withGatewayType(VirtualNetworkGatewayType.EXPRESS_ROUTE);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withRouteBasedVpn() {
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withGatewayType(VirtualNetworkGatewayType.VPN);
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withVpnType(VpnType.ROUTE_BASED);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withPolicyBasedVpn() {
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withGatewayType(VirtualNetworkGatewayType.VPN);
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withVpnType(VpnType.POLICY_BASED);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withSku(VirtualNetworkGatewaySkuName skuName) {
        VirtualNetworkGatewaySku sku = new VirtualNetworkGatewaySku().withName(skuName).withTier(VirtualNetworkGatewaySkuTier.fromString(skuName.toString()));
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withSku(sku);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewNetwork(Creatable<Network> creatable) {
        this.creatableNetwork = creatable;
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewNetwork(String name, String addressSpace, String subnetAddressSpaceCidr) {
        Network.DefinitionStages.WithGroup definitionWithGroup = (Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)((NetworkManager)this.manager()).networks().define(name)).withRegion(this.regionName());
        Network.DefinitionStages.WithCreate definitionAfterGroup = this.newGroup() != null ? (Network.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(this.newGroup()) : (Network.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        Network.DefinitionStages.WithCreateAndSubnet network = definitionAfterGroup.withAddressSpace(addressSpace).withSubnet(GATEWAY_SUBNET, subnetAddressSpaceCidr);
        return this.withNewNetwork(network);
    }

    @Override
    public VirtualNetworkGatewayImpl withNewNetwork(String addressSpaceCidr, String subnetAddressSpaceCidr) {
        this.withNewNetwork(((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("vnet", 8), addressSpaceCidr, subnetAddressSpaceCidr);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withExistingNetwork(Network network) {
        this.ensureDefaultIPConfig().withExistingSubnet(network, GATEWAY_SUBNET);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withExistingPublicIpAddress(PublicIpAddress publicIPAddress) {
        this.ensureDefaultIPConfig().withExistingPublicIpAddress(publicIPAddress);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withExistingPublicIpAddress(String resourceId) {
        this.ensureDefaultIPConfig().withExistingPublicIpAddress(resourceId);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewPublicIpAddress(Creatable<PublicIpAddress> creatable) {
        this.creatablePip = creatable;
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withNewPublicIpAddress() {
        String pipName = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("pip", 9);
        this.creatablePip = (Creatable)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIpAddresses().define(pipName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withoutBgp() {
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withBgpSettings(null);
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withEnableBgp(false);
        return this;
    }

    @Override
    public VirtualNetworkGatewayImpl withBgp(long asn, String bgpPeeringAddress) {
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withEnableBgp(true);
        this.ensureBgpSettings().withAsn(asn).withBgpPeeringAddress(bgpPeeringAddress);
        return this;
    }

    void attachPointToSiteConfiguration(PointToSiteConfigurationImpl pointToSiteConfiguration) {
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withVpnClientConfiguration((VpnClientConfiguration)pointToSiteConfiguration.innerModel());
    }

    @Override
    public void reset() {
        this.resetAsync().block();
    }

    @Override
    public Mono<Void> resetAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGateways().resetAsync(this.resourceGroupName(), this.name()).map(inner -> {
            this.setInner(inner);
            return Mono.empty();
        }).then();
    }

    @Override
    public PagedIterable<VirtualNetworkGatewayConnection> listConnections() {
        return new PagedIterable(this.listConnectionsAsync());
    }

    @Override
    public PagedFlux<VirtualNetworkGatewayConnection> listConnectionsAsync() {
        PagedFlux<VirtualNetworkGatewayConnectionListEntityInner> connectionInners = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGateways().listConnectionsAsync(this.resourceGroupName(), this.name());
        return PagedConverter.flatMapPage(connectionInners, connectionInner -> this.connections().getByIdAsync(connectionInner.id()));
    }

    @Override
    public String generateVpnProfile() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGateways().generateVpnProfile(this.resourceGroupName(), this.name(), new VpnClientParameters());
    }

    @Override
    public Mono<String> generateVpnProfileAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGateways().generateVpnProfileAsync(this.resourceGroupName(), this.name(), new VpnClientParameters());
    }

    @Override
    protected Mono<VirtualNetworkGatewayInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGateways().updateTagsAsync(this.resourceGroupName(), this.name(), ((VirtualNetworkGatewayInner)((Object)this.innerModel())).tags());
    }

    @Override
    public VirtualNetworkGatewayConnections connections() {
        if (this.connections == null) {
            this.connections = new VirtualNetworkGatewayConnectionsImpl(this);
        }
        return this.connections;
    }

    @Override
    public VirtualNetworkGatewayType gatewayType() {
        return ((VirtualNetworkGatewayInner)((Object)this.innerModel())).gatewayType();
    }

    @Override
    public VpnType vpnType() {
        return ((VirtualNetworkGatewayInner)((Object)this.innerModel())).vpnType();
    }

    @Override
    public boolean isBgpEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayInner)((Object)this.innerModel())).enableBgp());
    }

    @Override
    public boolean activeActive() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualNetworkGatewayInner)((Object)this.innerModel())).active());
    }

    @Override
    public String gatewayDefaultSiteResourceId() {
        return ((VirtualNetworkGatewayInner)((Object)this.innerModel())).gatewayDefaultSite() == null ? null : ((VirtualNetworkGatewayInner)((Object)this.innerModel())).gatewayDefaultSite().id();
    }

    @Override
    public VirtualNetworkGatewaySku sku() {
        return ((VirtualNetworkGatewayInner)((Object)this.innerModel())).sku();
    }

    @Override
    public VpnClientConfiguration vpnClientConfiguration() {
        return ((VirtualNetworkGatewayInner)((Object)this.innerModel())).vpnClientConfiguration();
    }

    @Override
    public BgpSettings bgpSettings() {
        return ((VirtualNetworkGatewayInner)((Object)this.innerModel())).bgpSettings();
    }

    @Override
    public Collection<VirtualNetworkGatewayIpConfiguration> ipConfigurations() {
        return Collections.unmodifiableCollection(this.ipConfigs.values());
    }

    Creatable<ResourceGroup> newGroup() {
        return this.creatableGroup;
    }

    protected void initializeChildrenFromInner() {
        this.initializeIPConfigsFromInner();
    }

    public Mono<VirtualNetworkGateway> refreshAsync() {
        return super.refreshAsync().map(virtualNetworkGateway -> {
            VirtualNetworkGatewayImpl impl = (VirtualNetworkGatewayImpl)virtualNetworkGateway;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<VirtualNetworkGatewayInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGateways().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    VirtualNetworkGatewayImpl withConfig(VirtualNetworkGatewayIpConfigurationImpl config) {
        if (config != null) {
            this.ipConfigs.put(config.name(), config);
        }
        return this;
    }

    private VirtualNetworkGatewayIpConfigurationImpl defineIPConfiguration(String name) {
        VirtualNetworkGatewayIpConfiguration ipConfig = this.ipConfigs.get(name);
        if (ipConfig == null) {
            VirtualNetworkGatewayIpConfigurationInner inner = new VirtualNetworkGatewayIpConfigurationInner().withName(name);
            return new VirtualNetworkGatewayIpConfigurationImpl(inner, this);
        }
        return (VirtualNetworkGatewayIpConfigurationImpl)ipConfig;
    }

    private void initializeIPConfigsFromInner() {
        this.ipConfigs = new TreeMap<String, VirtualNetworkGatewayIpConfiguration>();
        List<VirtualNetworkGatewayIpConfigurationInner> inners = ((VirtualNetworkGatewayInner)((Object)this.innerModel())).ipConfigurations();
        if (inners != null) {
            for (VirtualNetworkGatewayIpConfigurationInner inner : inners) {
                VirtualNetworkGatewayIpConfigurationImpl config = new VirtualNetworkGatewayIpConfigurationImpl(inner, this);
                this.ipConfigs.put(inner.name(), config);
            }
        }
    }

    protected void beforeCreating() {
        this.ensureDefaultIPConfig();
        ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withIpConfigurations(this.innersFromWrappers(this.ipConfigs.values()));
    }

    private BgpSettings ensureBgpSettings() {
        if (((VirtualNetworkGatewayInner)((Object)this.innerModel())).bgpSettings() == null) {
            ((VirtualNetworkGatewayInner)((Object)this.innerModel())).withBgpSettings(new BgpSettings());
        }
        return ((VirtualNetworkGatewayInner)((Object)this.innerModel())).bgpSettings();
    }

    private VirtualNetworkGatewayIpConfigurationImpl ensureDefaultIPConfig() {
        VirtualNetworkGatewayIpConfigurationImpl ipConfig = (VirtualNetworkGatewayIpConfigurationImpl)this.defaultIPConfiguration();
        if (ipConfig == null) {
            String name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("ipcfg", 11);
            ipConfig = this.defineIPConfiguration(name);
            ipConfig.attach();
        }
        return ipConfig;
    }

    private Creatable<PublicIpAddress> ensureDefaultPipDefinition() {
        if (this.creatablePip == null) {
            String pipName = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("pip", 9);
            this.creatablePip = (Creatable)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIpAddresses().define(pipName)).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
        }
        return this.creatablePip;
    }

    VirtualNetworkGatewayIpConfiguration defaultIPConfiguration() {
        if (this.ipConfigs.size() == 1) {
            return this.ipConfigs.values().iterator().next();
        }
        return null;
    }

    protected Mono<VirtualNetworkGatewayInner> createInner() {
        Mono networkObservable;
        VirtualNetworkGatewayIpConfigurationImpl defaultIPConfig = this.ensureDefaultIPConfig();
        Mono pipObservable = defaultIPConfig.publicIpAddressId() == null ? this.ensureDefaultPipDefinition().createAsync().map(publicIPAddress -> {
            defaultIPConfig.withExistingPublicIpAddress((PublicIpAddress)publicIPAddress);
            return publicIPAddress;
        }) : Mono.empty();
        if (defaultIPConfig.subnetName() != null) {
            networkObservable = Mono.empty();
        } else if (this.creatableNetwork != null) {
            networkObservable = this.creatableNetwork.createAsync().map(network -> {
                defaultIPConfig.withExistingSubnet((Network)network, GATEWAY_SUBNET);
                return network;
            });
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Creatable Network should not be null"));
        }
        return Flux.merge((Publisher[])new Publisher[]{networkObservable, pipObservable}).last((Object)Resource.DUMMY).flatMap(resource -> ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getVirtualNetworkGateways().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualNetworkGatewayInner)((Object)((Object)this.innerModel()))));
    }

    public PointToSiteConfigurationImpl definePointToSiteConfiguration() {
        return new PointToSiteConfigurationImpl(new VpnClientConfiguration(), this);
    }

    @Override
    public PointToSiteConfigurationImpl updatePointToSiteConfiguration() {
        return new PointToSiteConfigurationImpl(((VirtualNetworkGatewayInner)((Object)this.innerModel())).vpnClientConfiguration(), this);
    }
}

