/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.PublicIpAddressesClient;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.implementation.PublicIpAddressImpl;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.azure.resourcemanager.network.models.PublicIpAddresses;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import java.time.Duration;
import java.util.function.Function;

public class PublicIpAddressesImpl
extends TopLevelModifiableResourcesImpl<PublicIpAddress, PublicIpAddressImpl, PublicIpAddressInner, PublicIpAddressesClient, NetworkManager>
implements PublicIpAddresses {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    public PublicIpAddressesImpl(NetworkManager networkManager) {
        super((InnerSupportsListing)((NetworkManagementClient)networkManager.serviceClient()).getPublicIpAddresses(), (Manager)networkManager);
    }

    public PublicIpAddressImpl define(String name) {
        return this.wrapModel(name);
    }

    protected PublicIpAddressImpl wrapModel(String name) {
        PublicIpAddressInner inner = new PublicIpAddressInner();
        if (null == inner.dnsSettings()) {
            inner.withDnsSettings(new PublicIpAddressDnsSettings());
        }
        return new PublicIpAddressImpl(name, inner, (NetworkManager)this.manager());
    }

    protected PublicIpAddressImpl wrapModel(PublicIpAddressInner inner) {
        if (inner == null) {
            return null;
        }
        return new PublicIpAddressImpl(inner.id(), inner, (NetworkManager)this.manager());
    }

    @Override
    public Accepted<Void> beginDeleteById(String id) {
        return this.beginDeleteByResourceGroup(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Accepted<Void> beginDeleteByResourceGroup(String resourceGroupName, String name) {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((PublicIpAddressesClient)this.inner()).deleteWithResponseAsync(resourceGroupName, name).block(), Function.identity(), Void.class, null);
    }
}

