/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.LocalNetworkGatewaysClient;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayInner;
import com.azure.resourcemanager.network.implementation.LocalNetworkGatewayImpl;
import com.azure.resourcemanager.network.models.LocalNetworkGateway;
import com.azure.resourcemanager.network.models.LocalNetworkGateways;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class LocalNetworkGatewaysImpl
extends GroupableResourcesImpl<LocalNetworkGateway, LocalNetworkGatewayImpl, LocalNetworkGatewayInner, LocalNetworkGatewaysClient, NetworkManager>
implements LocalNetworkGateways {
    public LocalNetworkGatewaysImpl(NetworkManager networkManager) {
        super((Object)((NetworkManagementClient)networkManager.serviceClient()).getLocalNetworkGateways(), (Manager)networkManager);
    }

    public LocalNetworkGatewayImpl define(String name) {
        return this.wrapModel(name);
    }

    public PagedIterable<LocalNetworkGateway> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<LocalNetworkGateway> listAsync() {
        return PagedConverter.mergePagedFlux((PagedFlux)((NetworkManager)this.manager()).resourceManager().resourceGroups().listAsync(), rg -> ((LocalNetworkGatewaysClient)this.inner()).listByResourceGroupAsync(rg.name())).mapPage(this::wrapModel);
    }

    public PagedIterable<LocalNetworkGateway> listByResourceGroup(String groupName) {
        return this.wrapList(((LocalNetworkGatewaysClient)this.inner()).listByResourceGroup(groupName));
    }

    public PagedFlux<LocalNetworkGateway> listByResourceGroupAsync(String groupName) {
        return this.wrapPageAsync(((LocalNetworkGatewaysClient)this.inner()).listByResourceGroupAsync(groupName));
    }

    protected Mono<LocalNetworkGatewayInner> getInnerAsync(String groupName, String name) {
        return ((LocalNetworkGatewaysClient)this.inner()).getByResourceGroupAsync(groupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String groupName, String name) {
        return ((LocalNetworkGatewaysClient)this.inner()).deleteAsync(groupName, name);
    }

    protected LocalNetworkGatewayImpl wrapModel(String name) {
        LocalNetworkGatewayInner inner = new LocalNetworkGatewayInner();
        return new LocalNetworkGatewayImpl(name, inner, (NetworkManager)super.manager());
    }

    protected LocalNetworkGatewayImpl wrapModel(LocalNetworkGatewayInner inner) {
        if (inner == null) {
            return null;
        }
        return new LocalNetworkGatewayImpl(inner.name(), inner, (NetworkManager)this.manager());
    }
}

