/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ApplicationGatewayPrivateLinkResourcesClient;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayPrivateLinkResourceInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ApplicationGatewayPrivateLinkResourceListResult;
import reactor.core.publisher.Mono;

public final class ApplicationGatewayPrivateLinkResourcesClientImpl
implements ApplicationGatewayPrivateLinkResourcesClient {
    private final ClientLogger logger = new ClientLogger(ApplicationGatewayPrivateLinkResourcesClientImpl.class);
    private final ApplicationGatewayPrivateLinkResourcesService service;
    private final NetworkManagementClientImpl client;

    ApplicationGatewayPrivateLinkResourcesClientImpl(NetworkManagementClientImpl client) {
        this.service = (ApplicationGatewayPrivateLinkResourcesService)RestProxy.create(ApplicationGatewayPrivateLinkResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<ApplicationGatewayPrivateLinkResourceInner>> listSinglePageAsync(String resourceGroupName, String applicationGatewayName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (applicationGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, applicationGatewayName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).value(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationGatewayPrivateLinkResourceInner>> listSinglePageAsync(String resourceGroupName, String applicationGatewayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (applicationGatewayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationGatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, applicationGatewayName, "2020-05-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).value(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ApplicationGatewayPrivateLinkResourceInner> listAsync(String resourceGroupName, String applicationGatewayName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, applicationGatewayName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ApplicationGatewayPrivateLinkResourceInner> listAsync(String resourceGroupName, String applicationGatewayName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, applicationGatewayName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ApplicationGatewayPrivateLinkResourceInner> list(String resourceGroupName, String applicationGatewayName) {
        return new PagedIterable(this.listAsync(resourceGroupName, applicationGatewayName));
    }

    @Override
    public PagedIterable<ApplicationGatewayPrivateLinkResourceInner> list(String resourceGroupName, String applicationGatewayName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, applicationGatewayName, context));
    }

    private Mono<PagedResponse<ApplicationGatewayPrivateLinkResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).value(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationGatewayPrivateLinkResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).value(), ((ApplicationGatewayPrivateLinkResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface ApplicationGatewayPrivateLinkResourcesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationGatewayPrivateLinkResourceListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="applicationGatewayName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationGatewayPrivateLinkResourceListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

