/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationProfileInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import com.azure.resourcemanager.network.fluent.models.ServiceEndpointPolicyInner;
import com.azure.resourcemanager.network.models.Delegation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ResourceNavigationLink;
import com.azure.resourcemanager.network.models.ServiceAssociationLink;
import com.azure.resourcemanager.network.models.ServiceEndpointPropertiesFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class SubnetInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SubnetInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.addressPrefix")
    private String addressPrefix;
    @JsonProperty(value="properties.addressPrefixes")
    private List<String> addressPrefixes;
    @JsonProperty(value="properties.networkSecurityGroup")
    private NetworkSecurityGroupInner networkSecurityGroup;
    @JsonProperty(value="properties.routeTable")
    private RouteTableInner routeTable;
    @JsonProperty(value="properties.natGateway")
    private SubResource natGateway;
    @JsonProperty(value="properties.serviceEndpoints")
    private List<ServiceEndpointPropertiesFormat> serviceEndpoints;
    @JsonProperty(value="properties.serviceEndpointPolicies")
    private List<ServiceEndpointPolicyInner> serviceEndpointPolicies;
    @JsonProperty(value="properties.privateEndpoints", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointInner> privateEndpoints;
    @JsonProperty(value="properties.ipConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<IpConfigurationInner> ipConfigurations;
    @JsonProperty(value="properties.ipConfigurationProfiles", access=JsonProperty.Access.WRITE_ONLY)
    private List<IpConfigurationProfileInner> ipConfigurationProfiles;
    @JsonProperty(value="properties.ipAllocations")
    private List<SubResource> ipAllocations;
    @JsonProperty(value="properties.resourceNavigationLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResourceNavigationLink> resourceNavigationLinks;
    @JsonProperty(value="properties.serviceAssociationLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<ServiceAssociationLink> serviceAssociationLinks;
    @JsonProperty(value="properties.delegations")
    private List<Delegation> delegations;
    @JsonProperty(value="properties.purpose", access=JsonProperty.Access.WRITE_ONLY)
    private String purpose;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.privateEndpointNetworkPolicies")
    private String privateEndpointNetworkPolicies;
    @JsonProperty(value="properties.privateLinkServiceNetworkPolicies")
    private String privateLinkServiceNetworkPolicies;

    public String name() {
        return this.name;
    }

    public SubnetInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public SubnetInner withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public SubnetInner withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public SubnetInner withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public RouteTableInner routeTable() {
        return this.routeTable;
    }

    public SubnetInner withRouteTable(RouteTableInner routeTable) {
        this.routeTable = routeTable;
        return this;
    }

    public SubResource natGateway() {
        return this.natGateway;
    }

    public SubnetInner withNatGateway(SubResource natGateway) {
        this.natGateway = natGateway;
        return this;
    }

    public List<ServiceEndpointPropertiesFormat> serviceEndpoints() {
        return this.serviceEndpoints;
    }

    public SubnetInner withServiceEndpoints(List<ServiceEndpointPropertiesFormat> serviceEndpoints) {
        this.serviceEndpoints = serviceEndpoints;
        return this;
    }

    public List<ServiceEndpointPolicyInner> serviceEndpointPolicies() {
        return this.serviceEndpointPolicies;
    }

    public SubnetInner withServiceEndpointPolicies(List<ServiceEndpointPolicyInner> serviceEndpointPolicies) {
        this.serviceEndpointPolicies = serviceEndpointPolicies;
        return this;
    }

    public List<PrivateEndpointInner> privateEndpoints() {
        return this.privateEndpoints;
    }

    public List<IpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public List<IpConfigurationProfileInner> ipConfigurationProfiles() {
        return this.ipConfigurationProfiles;
    }

    public List<SubResource> ipAllocations() {
        return this.ipAllocations;
    }

    public SubnetInner withIpAllocations(List<SubResource> ipAllocations) {
        this.ipAllocations = ipAllocations;
        return this;
    }

    public List<ResourceNavigationLink> resourceNavigationLinks() {
        return this.resourceNavigationLinks;
    }

    public List<ServiceAssociationLink> serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    public List<Delegation> delegations() {
        return this.delegations;
    }

    public SubnetInner withDelegations(List<Delegation> delegations) {
        this.delegations = delegations;
        return this;
    }

    public String purpose() {
        return this.purpose;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String privateEndpointNetworkPolicies() {
        return this.privateEndpointNetworkPolicies;
    }

    public SubnetInner withPrivateEndpointNetworkPolicies(String privateEndpointNetworkPolicies) {
        this.privateEndpointNetworkPolicies = privateEndpointNetworkPolicies;
        return this;
    }

    public String privateLinkServiceNetworkPolicies() {
        return this.privateLinkServiceNetworkPolicies;
    }

    public SubnetInner withPrivateLinkServiceNetworkPolicies(String privateLinkServiceNetworkPolicies) {
        this.privateLinkServiceNetworkPolicies = privateLinkServiceNetworkPolicies;
        return this;
    }

    public void validate() {
        if (this.networkSecurityGroup() != null) {
            this.networkSecurityGroup().validate();
        }
        if (this.routeTable() != null) {
            this.routeTable().validate();
        }
        if (this.serviceEndpoints() != null) {
            this.serviceEndpoints().forEach(e -> e.validate());
        }
        if (this.serviceEndpointPolicies() != null) {
            this.serviceEndpointPolicies().forEach(e -> e.validate());
        }
        if (this.privateEndpoints() != null) {
            this.privateEndpoints().forEach(e -> e.validate());
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.ipConfigurationProfiles() != null) {
            this.ipConfigurationProfiles().forEach(e -> e.validate());
        }
        if (this.resourceNavigationLinks() != null) {
            this.resourceNavigationLinks().forEach(e -> e.validate());
        }
        if (this.serviceAssociationLinks() != null) {
            this.serviceAssociationLinks().forEach(e -> e.validate());
        }
        if (this.delegations() != null) {
            this.delegations().forEach(e -> e.validate());
        }
    }
}

