/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpPrefixSku;
import com.azure.resourcemanager.network.models.ReferencedPublicIpAddress;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class PublicIpPrefixInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PublicIpPrefixInner.class);
    @JsonProperty(value="sku")
    private PublicIpPrefixSku sku;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="properties.publicIPAddressVersion")
    private IpVersion publicIpAddressVersion;
    @JsonProperty(value="properties.ipTags")
    private List<IpTag> ipTags;
    @JsonProperty(value="properties.prefixLength")
    private Integer prefixLength;
    @JsonProperty(value="properties.ipPrefix", access=JsonProperty.Access.WRITE_ONLY)
    private String ipPrefix;
    @JsonProperty(value="properties.publicIPAddresses", access=JsonProperty.Access.WRITE_ONLY)
    private List<ReferencedPublicIpAddress> publicIpAddresses;
    @JsonProperty(value="properties.loadBalancerFrontendIpConfiguration", access=JsonProperty.Access.WRITE_ONLY)
    private SubResource loadBalancerFrontendIpConfiguration;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public PublicIpPrefixSku sku() {
        return this.sku;
    }

    public PublicIpPrefixInner withSku(PublicIpPrefixSku sku) {
        this.sku = sku;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public PublicIpPrefixInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public IpVersion publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    public PublicIpPrefixInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    public List<IpTag> ipTags() {
        return this.ipTags;
    }

    public PublicIpPrefixInner withIpTags(List<IpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public Integer prefixLength() {
        return this.prefixLength;
    }

    public PublicIpPrefixInner withPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public String ipPrefix() {
        return this.ipPrefix;
    }

    public List<ReferencedPublicIpAddress> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    public SubResource loadBalancerFrontendIpConfiguration() {
        return this.loadBalancerFrontendIpConfiguration;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public PublicIpPrefixInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.ipTags() != null) {
            this.ipTags().forEach(e -> e.validate());
        }
        if (this.publicIpAddresses() != null) {
            this.publicIpAddresses().forEach(e -> e.validate());
        }
    }
}

