/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class PrivateEndpointInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateEndpointInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.subnet")
    private SubnetInner subnet;
    @JsonProperty(value="properties.networkInterfaces", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceInner> networkInterfaces;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.privateLinkServiceConnections")
    private List<PrivateLinkServiceConnection> privateLinkServiceConnections;
    @JsonProperty(value="properties.manualPrivateLinkServiceConnections")
    private List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections;
    @JsonProperty(value="properties.customDnsConfigs")
    private List<CustomDnsConfigPropertiesFormat> customDnsConfigs;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public SubnetInner subnet() {
        return this.subnet;
    }

    public PrivateEndpointInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<PrivateLinkServiceConnection> privateLinkServiceConnections() {
        return this.privateLinkServiceConnections;
    }

    public PrivateEndpointInner withPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> privateLinkServiceConnections) {
        this.privateLinkServiceConnections = privateLinkServiceConnections;
        return this;
    }

    public List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections() {
        return this.manualPrivateLinkServiceConnections;
    }

    public PrivateEndpointInner withManualPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections) {
        this.manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections;
        return this;
    }

    public List<CustomDnsConfigPropertiesFormat> customDnsConfigs() {
        return this.customDnsConfigs;
    }

    public PrivateEndpointInner withCustomDnsConfigs(List<CustomDnsConfigPropertiesFormat> customDnsConfigs) {
        this.customDnsConfigs = customDnsConfigs;
        return this;
    }

    public String id() {
        return this.id;
    }

    public PrivateEndpointInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.privateLinkServiceConnections() != null) {
            this.privateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (this.manualPrivateLinkServiceConnections() != null) {
            this.manualPrivateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (this.customDnsConfigs() != null) {
            this.customDnsConfigs().forEach(e -> e.validate());
        }
    }
}

