/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AzureFirewallThreatIntelMode;
import com.azure.resourcemanager.network.models.DnsSettings;
import com.azure.resourcemanager.network.models.FirewallPolicyThreatIntelWhitelist;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class FirewallPolicyInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FirewallPolicyInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.ruleCollectionGroups", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> ruleCollectionGroups;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.basePolicy")
    private SubResource basePolicy;
    @JsonProperty(value="properties.firewalls", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> firewalls;
    @JsonProperty(value="properties.childPolicies", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> childPolicies;
    @JsonProperty(value="properties.threatIntelMode")
    private AzureFirewallThreatIntelMode threatIntelMode;
    @JsonProperty(value="properties.threatIntelWhitelist")
    private FirewallPolicyThreatIntelWhitelist threatIntelWhitelist;
    @JsonProperty(value="properties.dnsSettings")
    private DnsSettings dnsSettings;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public List<SubResource> ruleCollectionGroups() {
        return this.ruleCollectionGroups;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SubResource basePolicy() {
        return this.basePolicy;
    }

    public FirewallPolicyInner withBasePolicy(SubResource basePolicy) {
        this.basePolicy = basePolicy;
        return this;
    }

    public List<SubResource> firewalls() {
        return this.firewalls;
    }

    public List<SubResource> childPolicies() {
        return this.childPolicies;
    }

    public AzureFirewallThreatIntelMode threatIntelMode() {
        return this.threatIntelMode;
    }

    public FirewallPolicyInner withThreatIntelMode(AzureFirewallThreatIntelMode threatIntelMode) {
        this.threatIntelMode = threatIntelMode;
        return this;
    }

    public FirewallPolicyThreatIntelWhitelist threatIntelWhitelist() {
        return this.threatIntelWhitelist;
    }

    public FirewallPolicyInner withThreatIntelWhitelist(FirewallPolicyThreatIntelWhitelist threatIntelWhitelist) {
        this.threatIntelWhitelist = threatIntelWhitelist;
        return this;
    }

    public DnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public FirewallPolicyInner withDnsSettings(DnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public String id() {
        return this.id;
    }

    public FirewallPolicyInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.threatIntelWhitelist() != null) {
            this.threatIntelWhitelist().validate();
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
    }
}

