/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteLinkInner;
import com.azure.resourcemanager.network.models.ExpressRoutePortsEncapsulation;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ExpressRoutePortInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExpressRoutePortInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties.peeringLocation")
    private String peeringLocation;
    @JsonProperty(value="properties.bandwidthInGbps")
    private Integer bandwidthInGbps;
    @JsonProperty(value="properties.provisionedBandwidthInGbps", access=JsonProperty.Access.WRITE_ONLY)
    private Float provisionedBandwidthInGbps;
    @JsonProperty(value="properties.mtu", access=JsonProperty.Access.WRITE_ONLY)
    private String mtu;
    @JsonProperty(value="properties.encapsulation")
    private ExpressRoutePortsEncapsulation encapsulation;
    @JsonProperty(value="properties.etherType", access=JsonProperty.Access.WRITE_ONLY)
    private String etherType;
    @JsonProperty(value="properties.allocationDate", access=JsonProperty.Access.WRITE_ONLY)
    private String allocationDate;
    @JsonProperty(value="properties.links")
    private List<ExpressRouteLinkInner> links;
    @JsonProperty(value="properties.circuits", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> circuits;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ExpressRoutePortInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public ExpressRoutePortInner withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    public Integer bandwidthInGbps() {
        return this.bandwidthInGbps;
    }

    public ExpressRoutePortInner withBandwidthInGbps(Integer bandwidthInGbps) {
        this.bandwidthInGbps = bandwidthInGbps;
        return this;
    }

    public Float provisionedBandwidthInGbps() {
        return this.provisionedBandwidthInGbps;
    }

    public String mtu() {
        return this.mtu;
    }

    public ExpressRoutePortsEncapsulation encapsulation() {
        return this.encapsulation;
    }

    public ExpressRoutePortInner withEncapsulation(ExpressRoutePortsEncapsulation encapsulation) {
        this.encapsulation = encapsulation;
        return this;
    }

    public String etherType() {
        return this.etherType;
    }

    public String allocationDate() {
        return this.allocationDate;
    }

    public List<ExpressRouteLinkInner> links() {
        return this.links;
    }

    public ExpressRoutePortInner withLinks(List<ExpressRouteLinkInner> links) {
        this.links = links;
        return this;
    }

    public List<SubResource> circuits() {
        return this.circuits;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public String id() {
        return this.id;
    }

    public ExpressRoutePortInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.links() != null) {
            this.links().forEach(e -> e.validate());
        }
    }
}

