/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitReference;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ExpressRouteCrossConnectionInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExpressRouteCrossConnectionInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.primaryAzurePort", access=JsonProperty.Access.WRITE_ONLY)
    private String primaryAzurePort;
    @JsonProperty(value="properties.secondaryAzurePort", access=JsonProperty.Access.WRITE_ONLY)
    private String secondaryAzurePort;
    @JsonProperty(value="properties.sTag", access=JsonProperty.Access.WRITE_ONLY)
    private Integer stag;
    @JsonProperty(value="properties.peeringLocation")
    private String peeringLocation;
    @JsonProperty(value="properties.bandwidthInMbps")
    private Integer bandwidthInMbps;
    @JsonProperty(value="properties.expressRouteCircuit")
    private ExpressRouteCircuitReference expressRouteCircuit;
    @JsonProperty(value="properties.serviceProviderProvisioningState")
    private ServiceProviderProvisioningState serviceProviderProvisioningState;
    @JsonProperty(value="properties.serviceProviderNotes")
    private String serviceProviderNotes;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.peerings")
    private List<ExpressRouteCrossConnectionPeeringInner> peerings;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public String primaryAzurePort() {
        return this.primaryAzurePort;
    }

    public String secondaryAzurePort() {
        return this.secondaryAzurePort;
    }

    public Integer stag() {
        return this.stag;
    }

    public String peeringLocation() {
        return this.peeringLocation;
    }

    public ExpressRouteCrossConnectionInner withPeeringLocation(String peeringLocation) {
        this.peeringLocation = peeringLocation;
        return this;
    }

    public Integer bandwidthInMbps() {
        return this.bandwidthInMbps;
    }

    public ExpressRouteCrossConnectionInner withBandwidthInMbps(Integer bandwidthInMbps) {
        this.bandwidthInMbps = bandwidthInMbps;
        return this;
    }

    public ExpressRouteCircuitReference expressRouteCircuit() {
        return this.expressRouteCircuit;
    }

    public ExpressRouteCrossConnectionInner withExpressRouteCircuit(ExpressRouteCircuitReference expressRouteCircuit) {
        this.expressRouteCircuit = expressRouteCircuit;
        return this;
    }

    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return this.serviceProviderProvisioningState;
    }

    public ExpressRouteCrossConnectionInner withServiceProviderProvisioningState(ServiceProviderProvisioningState serviceProviderProvisioningState) {
        this.serviceProviderProvisioningState = serviceProviderProvisioningState;
        return this;
    }

    public String serviceProviderNotes() {
        return this.serviceProviderNotes;
    }

    public ExpressRouteCrossConnectionInner withServiceProviderNotes(String serviceProviderNotes) {
        this.serviceProviderNotes = serviceProviderNotes;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ExpressRouteCrossConnectionPeeringInner> peerings() {
        return this.peerings;
    }

    public ExpressRouteCrossConnectionInner withPeerings(List<ExpressRouteCrossConnectionPeeringInner> peerings) {
        this.peerings = peerings;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteCrossConnectionInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.expressRouteCircuit() != null) {
            this.expressRouteCircuit().validate();
        }
        if (this.peerings() != null) {
            this.peerings().forEach(e -> e.validate());
        }
    }
}

