/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpoint;
import com.azure.resourcemanager.network.models.ConnectionMonitorOutput;
import com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestGroup;
import com.azure.resourcemanager.network.models.ConnectionMonitorType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class ConnectionMonitorResultInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ConnectionMonitorResultInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.source")
    private ConnectionMonitorSource source;
    @JsonProperty(value="properties.destination")
    private ConnectionMonitorDestination destination;
    @JsonProperty(value="properties.autoStart")
    private Boolean autoStart;
    @JsonProperty(value="properties.monitoringIntervalInSeconds")
    private Integer monitoringIntervalInSeconds;
    @JsonProperty(value="properties.endpoints")
    private List<ConnectionMonitorEndpoint> endpoints;
    @JsonProperty(value="properties.testConfigurations")
    private List<ConnectionMonitorTestConfiguration> testConfigurations;
    @JsonProperty(value="properties.testGroups")
    private List<ConnectionMonitorTestGroup> testGroups;
    @JsonProperty(value="properties.outputs")
    private List<ConnectionMonitorOutput> outputs;
    @JsonProperty(value="properties.notes")
    private String notes;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.startTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;
    @JsonProperty(value="properties.monitoringStatus", access=JsonProperty.Access.WRITE_ONLY)
    private String monitoringStatus;
    @JsonProperty(value="properties.connectionMonitorType", access=JsonProperty.Access.WRITE_ONLY)
    private ConnectionMonitorType connectionMonitorType;

    public String etag() {
        return this.etag;
    }

    public ConnectionMonitorSource source() {
        return this.source;
    }

    public ConnectionMonitorResultInner withSource(ConnectionMonitorSource source) {
        this.source = source;
        return this;
    }

    public ConnectionMonitorDestination destination() {
        return this.destination;
    }

    public ConnectionMonitorResultInner withDestination(ConnectionMonitorDestination destination) {
        this.destination = destination;
        return this;
    }

    public Boolean autoStart() {
        return this.autoStart;
    }

    public ConnectionMonitorResultInner withAutoStart(Boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    public Integer monitoringIntervalInSeconds() {
        return this.monitoringIntervalInSeconds;
    }

    public ConnectionMonitorResultInner withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        this.monitoringIntervalInSeconds = monitoringIntervalInSeconds;
        return this;
    }

    public List<ConnectionMonitorEndpoint> endpoints() {
        return this.endpoints;
    }

    public ConnectionMonitorResultInner withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<ConnectionMonitorTestConfiguration> testConfigurations() {
        return this.testConfigurations;
    }

    public ConnectionMonitorResultInner withTestConfigurations(List<ConnectionMonitorTestConfiguration> testConfigurations) {
        this.testConfigurations = testConfigurations;
        return this;
    }

    public List<ConnectionMonitorTestGroup> testGroups() {
        return this.testGroups;
    }

    public ConnectionMonitorResultInner withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        this.testGroups = testGroups;
        return this;
    }

    public List<ConnectionMonitorOutput> outputs() {
        return this.outputs;
    }

    public ConnectionMonitorResultInner withOutputs(List<ConnectionMonitorOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    public String notes() {
        return this.notes;
    }

    public ConnectionMonitorResultInner withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public String monitoringStatus() {
        return this.monitoringStatus;
    }

    public ConnectionMonitorType connectionMonitorType() {
        return this.connectionMonitorType;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.destination() != null) {
            this.destination().validate();
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.testConfigurations() != null) {
            this.testConfigurations().forEach(e -> e.validate());
        }
        if (this.testGroups() != null) {
            this.testGroups().forEach(e -> e.validate());
        }
        if (this.outputs() != null) {
            this.outputs().forEach(e -> e.validate());
        }
    }
}

