/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.VolumeQuotaRuleInner;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.Type;
import java.util.Map;

public interface VolumeQuotaRule {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public ProvisioningState provisioningState();

    public Long quotaSizeInKiBs();

    public Type quotaType();

    public String quotaTarget();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public VolumeQuotaRuleInner innerModel();

    public Update update();

    public VolumeQuotaRule refresh();

    public VolumeQuotaRule refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithQuotaSizeInKiBs {
            public Update withQuotaSizeInKiBs(Long var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithQuotaSizeInKiBs {
        public VolumeQuotaRule apply();

        public VolumeQuotaRule apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithQuotaTarget {
            public WithCreate withQuotaTarget(String var1);
        }

        public static interface WithQuotaType {
            public WithCreate withQuotaType(Type var1);
        }

        public static interface WithQuotaSizeInKiBs {
            public WithCreate withQuotaSizeInKiBs(Long var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithQuotaSizeInKiBs,
        WithQuotaType,
        WithQuotaTarget {
            public VolumeQuotaRule create();

            public VolumeQuotaRule create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingVolume(String var1, String var2, String var3, String var4);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

