/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.RansomwareProtectionSettings;
import com.azure.resourcemanager.netapp.models.ReplicationObject;
import com.azure.resourcemanager.netapp.models.VolumeBackupProperties;
import com.azure.resourcemanager.netapp.models.VolumeRelocationProperties;
import com.azure.resourcemanager.netapp.models.VolumeSnapshotProperties;
import java.io.IOException;

public final class VolumePropertiesDataProtection
implements JsonSerializable<VolumePropertiesDataProtection> {
    private VolumeBackupProperties backup;
    private ReplicationObject replication;
    private VolumeSnapshotProperties snapshot;
    private VolumeRelocationProperties volumeRelocation;
    private RansomwareProtectionSettings ransomwareProtection;

    public VolumeBackupProperties backup() {
        return this.backup;
    }

    public VolumePropertiesDataProtection withBackup(VolumeBackupProperties backup) {
        this.backup = backup;
        return this;
    }

    public ReplicationObject replication() {
        return this.replication;
    }

    public VolumePropertiesDataProtection withReplication(ReplicationObject replication) {
        this.replication = replication;
        return this;
    }

    public VolumeSnapshotProperties snapshot() {
        return this.snapshot;
    }

    public VolumePropertiesDataProtection withSnapshot(VolumeSnapshotProperties snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public VolumeRelocationProperties volumeRelocation() {
        return this.volumeRelocation;
    }

    public VolumePropertiesDataProtection withVolumeRelocation(VolumeRelocationProperties volumeRelocation) {
        this.volumeRelocation = volumeRelocation;
        return this;
    }

    public RansomwareProtectionSettings ransomwareProtection() {
        return this.ransomwareProtection;
    }

    public VolumePropertiesDataProtection withRansomwareProtection(RansomwareProtectionSettings ransomwareProtection) {
        this.ransomwareProtection = ransomwareProtection;
        return this;
    }

    public void validate() {
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.replication() != null) {
            this.replication().validate();
        }
        if (this.snapshot() != null) {
            this.snapshot().validate();
        }
        if (this.volumeRelocation() != null) {
            this.volumeRelocation().validate();
        }
        if (this.ransomwareProtection() != null) {
            this.ransomwareProtection().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        jsonWriter.writeJsonField("replication", (JsonSerializable)this.replication);
        jsonWriter.writeJsonField("snapshot", (JsonSerializable)this.snapshot);
        jsonWriter.writeJsonField("volumeRelocation", (JsonSerializable)this.volumeRelocation);
        jsonWriter.writeJsonField("ransomwareProtection", (JsonSerializable)this.ransomwareProtection);
        return jsonWriter.writeEndObject();
    }

    public static VolumePropertiesDataProtection fromJson(JsonReader jsonReader) throws IOException {
        return (VolumePropertiesDataProtection)jsonReader.readObject(reader -> {
            VolumePropertiesDataProtection deserializedVolumePropertiesDataProtection = new VolumePropertiesDataProtection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backup".equals(fieldName)) {
                    deserializedVolumePropertiesDataProtection.backup = VolumeBackupProperties.fromJson(reader);
                    continue;
                }
                if ("replication".equals(fieldName)) {
                    deserializedVolumePropertiesDataProtection.replication = ReplicationObject.fromJson(reader);
                    continue;
                }
                if ("snapshot".equals(fieldName)) {
                    deserializedVolumePropertiesDataProtection.snapshot = VolumeSnapshotProperties.fromJson(reader);
                    continue;
                }
                if ("volumeRelocation".equals(fieldName)) {
                    deserializedVolumePropertiesDataProtection.volumeRelocation = VolumeRelocationProperties.fromJson(reader);
                    continue;
                }
                if ("ransomwareProtection".equals(fieldName)) {
                    deserializedVolumePropertiesDataProtection.ransomwareProtection = RansomwareProtectionSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumePropertiesDataProtection;
        });
    }
}

