/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.RansomwareProtectionPatchSettings;
import com.azure.resourcemanager.netapp.models.VolumeBackupProperties;
import com.azure.resourcemanager.netapp.models.VolumeSnapshotProperties;
import java.io.IOException;

public final class VolumePatchPropertiesDataProtection
implements JsonSerializable<VolumePatchPropertiesDataProtection> {
    private VolumeBackupProperties backup;
    private VolumeSnapshotProperties snapshot;
    private RansomwareProtectionPatchSettings ransomwareProtection;

    public VolumeBackupProperties backup() {
        return this.backup;
    }

    public VolumePatchPropertiesDataProtection withBackup(VolumeBackupProperties backup) {
        this.backup = backup;
        return this;
    }

    public VolumeSnapshotProperties snapshot() {
        return this.snapshot;
    }

    public VolumePatchPropertiesDataProtection withSnapshot(VolumeSnapshotProperties snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public RansomwareProtectionPatchSettings ransomwareProtection() {
        return this.ransomwareProtection;
    }

    public VolumePatchPropertiesDataProtection withRansomwareProtection(RansomwareProtectionPatchSettings ransomwareProtection) {
        this.ransomwareProtection = ransomwareProtection;
        return this;
    }

    public void validate() {
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.snapshot() != null) {
            this.snapshot().validate();
        }
        if (this.ransomwareProtection() != null) {
            this.ransomwareProtection().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        jsonWriter.writeJsonField("snapshot", (JsonSerializable)this.snapshot);
        jsonWriter.writeJsonField("ransomwareProtection", (JsonSerializable)this.ransomwareProtection);
        return jsonWriter.writeEndObject();
    }

    public static VolumePatchPropertiesDataProtection fromJson(JsonReader jsonReader) throws IOException {
        return (VolumePatchPropertiesDataProtection)jsonReader.readObject(reader -> {
            VolumePatchPropertiesDataProtection deserializedVolumePatchPropertiesDataProtection = new VolumePatchPropertiesDataProtection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backup".equals(fieldName)) {
                    deserializedVolumePatchPropertiesDataProtection.backup = VolumeBackupProperties.fromJson(reader);
                    continue;
                }
                if ("snapshot".equals(fieldName)) {
                    deserializedVolumePatchPropertiesDataProtection.snapshot = VolumeSnapshotProperties.fromJson(reader);
                    continue;
                }
                if ("ransomwareProtection".equals(fieldName)) {
                    deserializedVolumePatchPropertiesDataProtection.ransomwareProtection = RansomwareProtectionPatchSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumePatchPropertiesDataProtection;
        });
    }
}

