/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.VolumeProperties;
import com.azure.resourcemanager.netapp.models.AcceptGrowCapacityPoolForShortTermCloneSplit;
import com.azure.resourcemanager.netapp.models.AvsDataStore;
import com.azure.resourcemanager.netapp.models.BreakthroughMode;
import com.azure.resourcemanager.netapp.models.CoolAccessRetrievalPolicy;
import com.azure.resourcemanager.netapp.models.CoolAccessTieringPolicy;
import com.azure.resourcemanager.netapp.models.EnableSubvolumes;
import com.azure.resourcemanager.netapp.models.EncryptionKeySource;
import com.azure.resourcemanager.netapp.models.FileAccessLogs;
import com.azure.resourcemanager.netapp.models.LargeVolumeType;
import com.azure.resourcemanager.netapp.models.LdapServerType;
import com.azure.resourcemanager.netapp.models.MountTargetProperties;
import com.azure.resourcemanager.netapp.models.NetworkFeatures;
import com.azure.resourcemanager.netapp.models.PlacementKeyValuePairs;
import com.azure.resourcemanager.netapp.models.SecurityStyle;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import com.azure.resourcemanager.netapp.models.SmbAccessBasedEnumeration;
import com.azure.resourcemanager.netapp.models.SmbNonBrowsable;
import com.azure.resourcemanager.netapp.models.VolumeLanguage;
import com.azure.resourcemanager.netapp.models.VolumePropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.VolumeStorageToNetworkProximity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VolumeGroupVolumeProperties
implements JsonSerializable<VolumeGroupVolumeProperties> {
    private String id;
    private String name;
    private String type;
    private Map<String, String> tags;
    private List<String> zones;
    private VolumeProperties innerProperties = new VolumeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(VolumeGroupVolumeProperties.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public VolumeGroupVolumeProperties withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VolumeGroupVolumeProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VolumeGroupVolumeProperties withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    private VolumeProperties innerProperties() {
        return this.innerProperties;
    }

    public String fileSystemId() {
        return this.innerProperties() == null ? null : this.innerProperties().fileSystemId();
    }

    public String creationToken() {
        return this.innerProperties() == null ? null : this.innerProperties().creationToken();
    }

    public VolumeGroupVolumeProperties withCreationToken(String creationToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withCreationToken(creationToken);
        return this;
    }

    public ServiceLevel serviceLevel() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceLevel();
    }

    public VolumeGroupVolumeProperties withServiceLevel(ServiceLevel serviceLevel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withServiceLevel(serviceLevel);
        return this;
    }

    public long usageThreshold() {
        return this.innerProperties() == null ? 0L : this.innerProperties().usageThreshold();
    }

    public VolumeGroupVolumeProperties withUsageThreshold(long usageThreshold) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withUsageThreshold(usageThreshold);
        return this;
    }

    public VolumePropertiesExportPolicy exportPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().exportPolicy();
    }

    public VolumeGroupVolumeProperties withExportPolicy(VolumePropertiesExportPolicy exportPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withExportPolicy(exportPolicy);
        return this;
    }

    public List<String> protocolTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().protocolTypes();
    }

    public VolumeGroupVolumeProperties withProtocolTypes(List<String> protocolTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withProtocolTypes(protocolTypes);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String snapshotId() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotId();
    }

    public VolumeGroupVolumeProperties withSnapshotId(String snapshotId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSnapshotId(snapshotId);
        return this;
    }

    public Boolean deleteBaseSnapshot() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteBaseSnapshot();
    }

    public VolumeGroupVolumeProperties withDeleteBaseSnapshot(Boolean deleteBaseSnapshot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withDeleteBaseSnapshot(deleteBaseSnapshot);
        return this;
    }

    public String backupId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupId();
    }

    public VolumeGroupVolumeProperties withBackupId(String backupId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withBackupId(backupId);
        return this;
    }

    public String baremetalTenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().baremetalTenantId();
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public VolumeGroupVolumeProperties withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public NetworkFeatures networkFeatures() {
        return this.innerProperties() == null ? null : this.innerProperties().networkFeatures();
    }

    public VolumeGroupVolumeProperties withNetworkFeatures(NetworkFeatures networkFeatures) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withNetworkFeatures(networkFeatures);
        return this;
    }

    public NetworkFeatures effectiveNetworkFeatures() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveNetworkFeatures();
    }

    public String networkSiblingSetId() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSiblingSetId();
    }

    public VolumeStorageToNetworkProximity storageToNetworkProximity() {
        return this.innerProperties() == null ? null : this.innerProperties().storageToNetworkProximity();
    }

    public List<MountTargetProperties> mountTargets() {
        return this.innerProperties() == null ? null : this.innerProperties().mountTargets();
    }

    public String volumeType() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeType();
    }

    public VolumeGroupVolumeProperties withVolumeType(String volumeType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withVolumeType(volumeType);
        return this;
    }

    public VolumePropertiesDataProtection dataProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().dataProtection();
    }

    public VolumeGroupVolumeProperties withDataProtection(VolumePropertiesDataProtection dataProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withDataProtection(dataProtection);
        return this;
    }

    public AcceptGrowCapacityPoolForShortTermCloneSplit acceptGrowCapacityPoolForShortTermCloneSplit() {
        return this.innerProperties() == null ? null : this.innerProperties().acceptGrowCapacityPoolForShortTermCloneSplit();
    }

    public VolumeGroupVolumeProperties withAcceptGrowCapacityPoolForShortTermCloneSplit(AcceptGrowCapacityPoolForShortTermCloneSplit acceptGrowCapacityPoolForShortTermCloneSplit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withAcceptGrowCapacityPoolForShortTermCloneSplit(acceptGrowCapacityPoolForShortTermCloneSplit);
        return this;
    }

    public Boolean isRestoring() {
        return this.innerProperties() == null ? null : this.innerProperties().isRestoring();
    }

    public Boolean snapshotDirectoryVisible() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotDirectoryVisible();
    }

    public VolumeGroupVolumeProperties withSnapshotDirectoryVisible(Boolean snapshotDirectoryVisible) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSnapshotDirectoryVisible(snapshotDirectoryVisible);
        return this;
    }

    public Boolean kerberosEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().kerberosEnabled();
    }

    public VolumeGroupVolumeProperties withKerberosEnabled(Boolean kerberosEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withKerberosEnabled(kerberosEnabled);
        return this;
    }

    public SecurityStyle securityStyle() {
        return this.innerProperties() == null ? null : this.innerProperties().securityStyle();
    }

    public VolumeGroupVolumeProperties withSecurityStyle(SecurityStyle securityStyle) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSecurityStyle(securityStyle);
        return this;
    }

    public Boolean smbEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().smbEncryption();
    }

    public VolumeGroupVolumeProperties withSmbEncryption(Boolean smbEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSmbEncryption(smbEncryption);
        return this;
    }

    public SmbAccessBasedEnumeration smbAccessBasedEnumeration() {
        return this.innerProperties() == null ? null : this.innerProperties().smbAccessBasedEnumeration();
    }

    public VolumeGroupVolumeProperties withSmbAccessBasedEnumeration(SmbAccessBasedEnumeration smbAccessBasedEnumeration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSmbAccessBasedEnumeration(smbAccessBasedEnumeration);
        return this;
    }

    public SmbNonBrowsable smbNonBrowsable() {
        return this.innerProperties() == null ? null : this.innerProperties().smbNonBrowsable();
    }

    public VolumeGroupVolumeProperties withSmbNonBrowsable(SmbNonBrowsable smbNonBrowsable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSmbNonBrowsable(smbNonBrowsable);
        return this;
    }

    public Boolean smbContinuouslyAvailable() {
        return this.innerProperties() == null ? null : this.innerProperties().smbContinuouslyAvailable();
    }

    public VolumeGroupVolumeProperties withSmbContinuouslyAvailable(Boolean smbContinuouslyAvailable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withSmbContinuouslyAvailable(smbContinuouslyAvailable);
        return this;
    }

    public Float throughputMibps() {
        return this.innerProperties() == null ? null : this.innerProperties().throughputMibps();
    }

    public VolumeGroupVolumeProperties withThroughputMibps(Float throughputMibps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withThroughputMibps(throughputMibps);
        return this;
    }

    public Float actualThroughputMibps() {
        return this.innerProperties() == null ? null : this.innerProperties().actualThroughputMibps();
    }

    public EncryptionKeySource encryptionKeySource() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionKeySource();
    }

    public VolumeGroupVolumeProperties withEncryptionKeySource(EncryptionKeySource encryptionKeySource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withEncryptionKeySource(encryptionKeySource);
        return this;
    }

    public String keyVaultPrivateEndpointResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultPrivateEndpointResourceId();
    }

    public VolumeGroupVolumeProperties withKeyVaultPrivateEndpointResourceId(String keyVaultPrivateEndpointResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withKeyVaultPrivateEndpointResourceId(keyVaultPrivateEndpointResourceId);
        return this;
    }

    public Boolean ldapEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().ldapEnabled();
    }

    public VolumeGroupVolumeProperties withLdapEnabled(Boolean ldapEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withLdapEnabled(ldapEnabled);
        return this;
    }

    public LdapServerType ldapServerType() {
        return this.innerProperties() == null ? null : this.innerProperties().ldapServerType();
    }

    public VolumeGroupVolumeProperties withLdapServerType(LdapServerType ldapServerType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withLdapServerType(ldapServerType);
        return this;
    }

    public Boolean coolAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccess();
    }

    public VolumeGroupVolumeProperties withCoolAccess(Boolean coolAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withCoolAccess(coolAccess);
        return this;
    }

    public Integer coolnessPeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().coolnessPeriod();
    }

    public VolumeGroupVolumeProperties withCoolnessPeriod(Integer coolnessPeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withCoolnessPeriod(coolnessPeriod);
        return this;
    }

    public CoolAccessRetrievalPolicy coolAccessRetrievalPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccessRetrievalPolicy();
    }

    public VolumeGroupVolumeProperties withCoolAccessRetrievalPolicy(CoolAccessRetrievalPolicy coolAccessRetrievalPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withCoolAccessRetrievalPolicy(coolAccessRetrievalPolicy);
        return this;
    }

    public CoolAccessTieringPolicy coolAccessTieringPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().coolAccessTieringPolicy();
    }

    public VolumeGroupVolumeProperties withCoolAccessTieringPolicy(CoolAccessTieringPolicy coolAccessTieringPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withCoolAccessTieringPolicy(coolAccessTieringPolicy);
        return this;
    }

    public String unixPermissions() {
        return this.innerProperties() == null ? null : this.innerProperties().unixPermissions();
    }

    public VolumeGroupVolumeProperties withUnixPermissions(String unixPermissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withUnixPermissions(unixPermissions);
        return this;
    }

    public Integer cloneProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().cloneProgress();
    }

    public FileAccessLogs fileAccessLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().fileAccessLogs();
    }

    public AvsDataStore avsDataStore() {
        return this.innerProperties() == null ? null : this.innerProperties().avsDataStore();
    }

    public VolumeGroupVolumeProperties withAvsDataStore(AvsDataStore avsDataStore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withAvsDataStore(avsDataStore);
        return this;
    }

    public List<String> dataStoreResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataStoreResourceId();
    }

    public Boolean isDefaultQuotaEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isDefaultQuotaEnabled();
    }

    public VolumeGroupVolumeProperties withIsDefaultQuotaEnabled(Boolean isDefaultQuotaEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withIsDefaultQuotaEnabled(isDefaultQuotaEnabled);
        return this;
    }

    public Long defaultUserQuotaInKiBs() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultUserQuotaInKiBs();
    }

    public VolumeGroupVolumeProperties withDefaultUserQuotaInKiBs(Long defaultUserQuotaInKiBs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withDefaultUserQuotaInKiBs(defaultUserQuotaInKiBs);
        return this;
    }

    public Long defaultGroupQuotaInKiBs() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultGroupQuotaInKiBs();
    }

    public VolumeGroupVolumeProperties withDefaultGroupQuotaInKiBs(Long defaultGroupQuotaInKiBs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withDefaultGroupQuotaInKiBs(defaultGroupQuotaInKiBs);
        return this;
    }

    public Long maximumNumberOfFiles() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfFiles();
    }

    public String volumeGroupName() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeGroupName();
    }

    public String capacityPoolResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().capacityPoolResourceId();
    }

    public VolumeGroupVolumeProperties withCapacityPoolResourceId(String capacityPoolResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withCapacityPoolResourceId(capacityPoolResourceId);
        return this;
    }

    public String proximityPlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroup();
    }

    public VolumeGroupVolumeProperties withProximityPlacementGroup(String proximityPlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    public String t2Network() {
        return this.innerProperties() == null ? null : this.innerProperties().t2Network();
    }

    public String volumeSpecName() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeSpecName();
    }

    public VolumeGroupVolumeProperties withVolumeSpecName(String volumeSpecName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withVolumeSpecName(volumeSpecName);
        return this;
    }

    public Boolean encrypted() {
        return this.innerProperties() == null ? null : this.innerProperties().encrypted();
    }

    public List<PlacementKeyValuePairs> placementRules() {
        return this.innerProperties() == null ? null : this.innerProperties().placementRules();
    }

    public VolumeGroupVolumeProperties withPlacementRules(List<PlacementKeyValuePairs> placementRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withPlacementRules(placementRules);
        return this;
    }

    public EnableSubvolumes enableSubvolumes() {
        return this.innerProperties() == null ? null : this.innerProperties().enableSubvolumes();
    }

    public VolumeGroupVolumeProperties withEnableSubvolumes(EnableSubvolumes enableSubvolumes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withEnableSubvolumes(enableSubvolumes);
        return this;
    }

    public String provisionedAvailabilityZone() {
        return this.innerProperties() == null ? null : this.innerProperties().provisionedAvailabilityZone();
    }

    public Boolean isLargeVolume() {
        return this.innerProperties() == null ? null : this.innerProperties().isLargeVolume();
    }

    public VolumeGroupVolumeProperties withIsLargeVolume(Boolean isLargeVolume) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withIsLargeVolume(isLargeVolume);
        return this;
    }

    public LargeVolumeType largeVolumeType() {
        return this.innerProperties() == null ? null : this.innerProperties().largeVolumeType();
    }

    public VolumeGroupVolumeProperties withLargeVolumeType(LargeVolumeType largeVolumeType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withLargeVolumeType(largeVolumeType);
        return this;
    }

    public String originatingResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().originatingResourceId();
    }

    public Long inheritedSizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().inheritedSizeInBytes();
    }

    public VolumeLanguage language() {
        return this.innerProperties() == null ? null : this.innerProperties().language();
    }

    public VolumeGroupVolumeProperties withLanguage(VolumeLanguage language) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withLanguage(language);
        return this;
    }

    public BreakthroughMode breakthroughMode() {
        return this.innerProperties() == null ? null : this.innerProperties().breakthroughMode();
    }

    public VolumeGroupVolumeProperties withBreakthroughMode(BreakthroughMode breakthroughMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VolumeProperties();
        }
        this.innerProperties().withBreakthroughMode(breakthroughMode);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VolumeGroupVolumeProperties"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VolumeGroupVolumeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeGroupVolumeProperties)jsonReader.readObject(reader -> {
            VolumeGroupVolumeProperties deserializedVolumeGroupVolumeProperties = new VolumeGroupVolumeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedVolumeGroupVolumeProperties.innerProperties = VolumeProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVolumeGroupVolumeProperties.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVolumeGroupVolumeProperties.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVolumeGroupVolumeProperties.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedVolumeGroupVolumeProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedVolumeGroupVolumeProperties.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeGroupVolumeProperties;
        });
    }
}

