/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.VolumeInner;
import com.azure.resourcemanager.netapp.models.AcceptGrowCapacityPoolForShortTermCloneSplit;
import com.azure.resourcemanager.netapp.models.AuthorizeRequest;
import com.azure.resourcemanager.netapp.models.AvsDataStore;
import com.azure.resourcemanager.netapp.models.BreakFileLocksRequest;
import com.azure.resourcemanager.netapp.models.BreakReplicationRequest;
import com.azure.resourcemanager.netapp.models.BreakthroughMode;
import com.azure.resourcemanager.netapp.models.ClusterPeerCommandResponse;
import com.azure.resourcemanager.netapp.models.CoolAccessRetrievalPolicy;
import com.azure.resourcemanager.netapp.models.CoolAccessTieringPolicy;
import com.azure.resourcemanager.netapp.models.EnableSubvolumes;
import com.azure.resourcemanager.netapp.models.EncryptionKeySource;
import com.azure.resourcemanager.netapp.models.FileAccessLogs;
import com.azure.resourcemanager.netapp.models.GetGroupIdListForLdapUserRequest;
import com.azure.resourcemanager.netapp.models.GetGroupIdListForLdapUserResponse;
import com.azure.resourcemanager.netapp.models.LargeVolumeType;
import com.azure.resourcemanager.netapp.models.LdapServerType;
import com.azure.resourcemanager.netapp.models.ListQuotaReportResponse;
import com.azure.resourcemanager.netapp.models.ListReplicationsRequest;
import com.azure.resourcemanager.netapp.models.MountTargetProperties;
import com.azure.resourcemanager.netapp.models.NetworkFeatures;
import com.azure.resourcemanager.netapp.models.PeerClusterForVolumeMigrationRequest;
import com.azure.resourcemanager.netapp.models.PlacementKeyValuePairs;
import com.azure.resourcemanager.netapp.models.PoolChangeRequest;
import com.azure.resourcemanager.netapp.models.ReestablishReplicationRequest;
import com.azure.resourcemanager.netapp.models.RelocateVolumeRequest;
import com.azure.resourcemanager.netapp.models.Replication;
import com.azure.resourcemanager.netapp.models.SecurityStyle;
import com.azure.resourcemanager.netapp.models.ServiceLevel;
import com.azure.resourcemanager.netapp.models.SmbAccessBasedEnumeration;
import com.azure.resourcemanager.netapp.models.SmbNonBrowsable;
import com.azure.resourcemanager.netapp.models.SvmPeerCommandResponse;
import com.azure.resourcemanager.netapp.models.VolumeLanguage;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePatchPropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.VolumePropertiesDataProtection;
import com.azure.resourcemanager.netapp.models.VolumePropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.VolumeRevert;
import com.azure.resourcemanager.netapp.models.VolumeStorageToNetworkProximity;
import java.util.List;
import java.util.Map;

public interface Volume {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public List<String> zones();

    public SystemData systemData();

    public String fileSystemId();

    public String creationToken();

    public ServiceLevel serviceLevel();

    public long usageThreshold();

    public VolumePropertiesExportPolicy exportPolicy();

    public List<String> protocolTypes();

    public String provisioningState();

    public String snapshotId();

    public Boolean deleteBaseSnapshot();

    public String backupId();

    public String baremetalTenantId();

    public String subnetId();

    public NetworkFeatures networkFeatures();

    public NetworkFeatures effectiveNetworkFeatures();

    public String networkSiblingSetId();

    public VolumeStorageToNetworkProximity storageToNetworkProximity();

    public List<MountTargetProperties> mountTargets();

    public String volumeType();

    public VolumePropertiesDataProtection dataProtection();

    public AcceptGrowCapacityPoolForShortTermCloneSplit acceptGrowCapacityPoolForShortTermCloneSplit();

    public Boolean isRestoring();

    public Boolean snapshotDirectoryVisible();

    public Boolean kerberosEnabled();

    public SecurityStyle securityStyle();

    public Boolean smbEncryption();

    public SmbAccessBasedEnumeration smbAccessBasedEnumeration();

    public SmbNonBrowsable smbNonBrowsable();

    public Boolean smbContinuouslyAvailable();

    public Float throughputMibps();

    public Float actualThroughputMibps();

    public EncryptionKeySource encryptionKeySource();

    public String keyVaultPrivateEndpointResourceId();

    public Boolean ldapEnabled();

    public LdapServerType ldapServerType();

    public Boolean coolAccess();

    public Integer coolnessPeriod();

    public CoolAccessRetrievalPolicy coolAccessRetrievalPolicy();

    public CoolAccessTieringPolicy coolAccessTieringPolicy();

    public String unixPermissions();

    public Integer cloneProgress();

    public FileAccessLogs fileAccessLogs();

    public AvsDataStore avsDataStore();

    public List<String> dataStoreResourceId();

    public Boolean isDefaultQuotaEnabled();

    public Long defaultUserQuotaInKiBs();

    public Long defaultGroupQuotaInKiBs();

    public Long maximumNumberOfFiles();

    public String volumeGroupName();

    public String capacityPoolResourceId();

    public String proximityPlacementGroup();

    public String t2Network();

    public String volumeSpecName();

    public Boolean encrypted();

    public List<PlacementKeyValuePairs> placementRules();

    public EnableSubvolumes enableSubvolumes();

    public String provisionedAvailabilityZone();

    public Boolean isLargeVolume();

    public LargeVolumeType largeVolumeType();

    public String originatingResourceId();

    public Long inheritedSizeInBytes();

    public VolumeLanguage language();

    public BreakthroughMode breakthroughMode();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public VolumeInner innerModel();

    public Update update();

    public Volume refresh();

    public Volume refresh(Context var1);

    public Volume populateAvailabilityZone();

    public Volume populateAvailabilityZone(Context var1);

    public void revert(VolumeRevert var1);

    public void revert(VolumeRevert var1, Context var2);

    public void resetCifsPassword();

    public void resetCifsPassword(Context var1);

    public Volume splitCloneFromParent();

    public Volume splitCloneFromParent(Context var1);

    public void breakFileLocks();

    public void breakFileLocks(BreakFileLocksRequest var1, Context var2);

    public GetGroupIdListForLdapUserResponse listGetGroupIdListForLdapUser(GetGroupIdListForLdapUserRequest var1);

    public GetGroupIdListForLdapUserResponse listGetGroupIdListForLdapUser(GetGroupIdListForLdapUserRequest var1, Context var2);

    public void breakReplication();

    public void breakReplication(BreakReplicationRequest var1, Context var2);

    public void reestablishReplication(ReestablishReplicationRequest var1);

    public void reestablishReplication(ReestablishReplicationRequest var1, Context var2);

    public PagedIterable<Replication> listReplications();

    public PagedIterable<Replication> listReplications(ListReplicationsRequest var1, Context var2);

    public void resyncReplication();

    public void resyncReplication(Context var1);

    public void deleteReplication();

    public void deleteReplication(Context var1);

    public void authorizeReplication(AuthorizeRequest var1);

    public void authorizeReplication(AuthorizeRequest var1, Context var2);

    public void reInitializeReplication();

    public void reInitializeReplication(Context var1);

    public ClusterPeerCommandResponse peerExternalCluster(PeerClusterForVolumeMigrationRequest var1);

    public ClusterPeerCommandResponse peerExternalCluster(PeerClusterForVolumeMigrationRequest var1, Context var2);

    public SvmPeerCommandResponse authorizeExternalReplication();

    public SvmPeerCommandResponse authorizeExternalReplication(Context var1);

    public void finalizeExternalReplication();

    public void finalizeExternalReplication(Context var1);

    public void performReplicationTransfer();

    public void performReplicationTransfer(Context var1);

    public void poolChange(PoolChangeRequest var1);

    public void poolChange(PoolChangeRequest var1, Context var2);

    public void relocate();

    public void relocate(RelocateVolumeRequest var1, Context var2);

    public void finalizeRelocation();

    public void finalizeRelocation(Context var1);

    public void revertRelocation();

    public void revertRelocation(Context var1);

    public ListQuotaReportResponse listQuotaReport();

    public ListQuotaReportResponse listQuotaReport(Context var1);

    public static interface UpdateStages {

        public static interface WithSmbNonBrowsable {
            public Update withSmbNonBrowsable(SmbNonBrowsable var1);
        }

        public static interface WithSmbAccessBasedEnumeration {
            public Update withSmbAccessBasedEnumeration(SmbAccessBasedEnumeration var1);
        }

        public static interface WithSnapshotDirectoryVisible {
            public Update withSnapshotDirectoryVisible(Boolean var1);
        }

        public static interface WithCoolAccessTieringPolicy {
            public Update withCoolAccessTieringPolicy(CoolAccessTieringPolicy var1);
        }

        public static interface WithCoolAccessRetrievalPolicy {
            public Update withCoolAccessRetrievalPolicy(CoolAccessRetrievalPolicy var1);
        }

        public static interface WithCoolnessPeriod {
            public Update withCoolnessPeriod(Integer var1);
        }

        public static interface WithCoolAccess {
            public Update withCoolAccess(Boolean var1);
        }

        public static interface WithUnixPermissions {
            public Update withUnixPermissions(String var1);
        }

        public static interface WithDefaultGroupQuotaInKiBs {
            public Update withDefaultGroupQuotaInKiBs(Long var1);
        }

        public static interface WithDefaultUserQuotaInKiBs {
            public Update withDefaultUserQuotaInKiBs(Long var1);
        }

        public static interface WithIsDefaultQuotaEnabled {
            public Update withIsDefaultQuotaEnabled(Boolean var1);
        }

        public static interface WithDataProtection {
            public Update withDataProtection(VolumePatchPropertiesDataProtection var1);
        }

        public static interface WithThroughputMibps {
            public Update withThroughputMibps(Float var1);
        }

        public static interface WithProtocolTypes {
            public Update withProtocolTypes(List<String> var1);
        }

        public static interface WithExportPolicy {
            public Update withExportPolicy(VolumePatchPropertiesExportPolicy var1);
        }

        public static interface WithUsageThreshold {
            public Update withUsageThreshold(Long var1);
        }

        public static interface WithServiceLevel {
            public Update withServiceLevel(ServiceLevel var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithServiceLevel,
    UpdateStages.WithUsageThreshold,
    UpdateStages.WithExportPolicy,
    UpdateStages.WithProtocolTypes,
    UpdateStages.WithThroughputMibps,
    UpdateStages.WithDataProtection,
    UpdateStages.WithIsDefaultQuotaEnabled,
    UpdateStages.WithDefaultUserQuotaInKiBs,
    UpdateStages.WithDefaultGroupQuotaInKiBs,
    UpdateStages.WithUnixPermissions,
    UpdateStages.WithCoolAccess,
    UpdateStages.WithCoolnessPeriod,
    UpdateStages.WithCoolAccessRetrievalPolicy,
    UpdateStages.WithCoolAccessTieringPolicy,
    UpdateStages.WithSnapshotDirectoryVisible,
    UpdateStages.WithSmbAccessBasedEnumeration,
    UpdateStages.WithSmbNonBrowsable {
        public Volume apply();

        public Volume apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithBreakthroughMode {
            public WithCreate withBreakthroughMode(BreakthroughMode var1);
        }

        public static interface WithLanguage {
            public WithCreate withLanguage(VolumeLanguage var1);
        }

        public static interface WithLargeVolumeType {
            public WithCreate withLargeVolumeType(LargeVolumeType var1);
        }

        public static interface WithIsLargeVolume {
            public WithCreate withIsLargeVolume(Boolean var1);
        }

        public static interface WithEnableSubvolumes {
            public WithCreate withEnableSubvolumes(EnableSubvolumes var1);
        }

        public static interface WithPlacementRules {
            public WithCreate withPlacementRules(List<PlacementKeyValuePairs> var1);
        }

        public static interface WithVolumeSpecName {
            public WithCreate withVolumeSpecName(String var1);
        }

        public static interface WithProximityPlacementGroup {
            public WithCreate withProximityPlacementGroup(String var1);
        }

        public static interface WithCapacityPoolResourceId {
            public WithCreate withCapacityPoolResourceId(String var1);
        }

        public static interface WithDefaultGroupQuotaInKiBs {
            public WithCreate withDefaultGroupQuotaInKiBs(Long var1);
        }

        public static interface WithDefaultUserQuotaInKiBs {
            public WithCreate withDefaultUserQuotaInKiBs(Long var1);
        }

        public static interface WithIsDefaultQuotaEnabled {
            public WithCreate withIsDefaultQuotaEnabled(Boolean var1);
        }

        public static interface WithAvsDataStore {
            public WithCreate withAvsDataStore(AvsDataStore var1);
        }

        public static interface WithUnixPermissions {
            public WithCreate withUnixPermissions(String var1);
        }

        public static interface WithCoolAccessTieringPolicy {
            public WithCreate withCoolAccessTieringPolicy(CoolAccessTieringPolicy var1);
        }

        public static interface WithCoolAccessRetrievalPolicy {
            public WithCreate withCoolAccessRetrievalPolicy(CoolAccessRetrievalPolicy var1);
        }

        public static interface WithCoolnessPeriod {
            public WithCreate withCoolnessPeriod(Integer var1);
        }

        public static interface WithCoolAccess {
            public WithCreate withCoolAccess(Boolean var1);
        }

        public static interface WithLdapServerType {
            public WithCreate withLdapServerType(LdapServerType var1);
        }

        public static interface WithLdapEnabled {
            public WithCreate withLdapEnabled(Boolean var1);
        }

        public static interface WithKeyVaultPrivateEndpointResourceId {
            public WithCreate withKeyVaultPrivateEndpointResourceId(String var1);
        }

        public static interface WithEncryptionKeySource {
            public WithCreate withEncryptionKeySource(EncryptionKeySource var1);
        }

        public static interface WithThroughputMibps {
            public WithCreate withThroughputMibps(Float var1);
        }

        public static interface WithSmbContinuouslyAvailable {
            public WithCreate withSmbContinuouslyAvailable(Boolean var1);
        }

        public static interface WithSmbNonBrowsable {
            public WithCreate withSmbNonBrowsable(SmbNonBrowsable var1);
        }

        public static interface WithSmbAccessBasedEnumeration {
            public WithCreate withSmbAccessBasedEnumeration(SmbAccessBasedEnumeration var1);
        }

        public static interface WithSmbEncryption {
            public WithCreate withSmbEncryption(Boolean var1);
        }

        public static interface WithSecurityStyle {
            public WithCreate withSecurityStyle(SecurityStyle var1);
        }

        public static interface WithKerberosEnabled {
            public WithCreate withKerberosEnabled(Boolean var1);
        }

        public static interface WithSnapshotDirectoryVisible {
            public WithCreate withSnapshotDirectoryVisible(Boolean var1);
        }

        public static interface WithAcceptGrowCapacityPoolForShortTermCloneSplit {
            public WithCreate withAcceptGrowCapacityPoolForShortTermCloneSplit(AcceptGrowCapacityPoolForShortTermCloneSplit var1);
        }

        public static interface WithDataProtection {
            public WithCreate withDataProtection(VolumePropertiesDataProtection var1);
        }

        public static interface WithVolumeType {
            public WithCreate withVolumeType(String var1);
        }

        public static interface WithNetworkFeatures {
            public WithCreate withNetworkFeatures(NetworkFeatures var1);
        }

        public static interface WithBackupId {
            public WithCreate withBackupId(String var1);
        }

        public static interface WithDeleteBaseSnapshot {
            public WithCreate withDeleteBaseSnapshot(Boolean var1);
        }

        public static interface WithSnapshotId {
            public WithCreate withSnapshotId(String var1);
        }

        public static interface WithProtocolTypes {
            public WithCreate withProtocolTypes(List<String> var1);
        }

        public static interface WithExportPolicy {
            public WithCreate withExportPolicy(VolumePropertiesExportPolicy var1);
        }

        public static interface WithServiceLevel {
            public WithCreate withServiceLevel(ServiceLevel var1);
        }

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithZones,
        WithServiceLevel,
        WithExportPolicy,
        WithProtocolTypes,
        WithSnapshotId,
        WithDeleteBaseSnapshot,
        WithBackupId,
        WithNetworkFeatures,
        WithVolumeType,
        WithDataProtection,
        WithAcceptGrowCapacityPoolForShortTermCloneSplit,
        WithSnapshotDirectoryVisible,
        WithKerberosEnabled,
        WithSecurityStyle,
        WithSmbEncryption,
        WithSmbAccessBasedEnumeration,
        WithSmbNonBrowsable,
        WithSmbContinuouslyAvailable,
        WithThroughputMibps,
        WithEncryptionKeySource,
        WithKeyVaultPrivateEndpointResourceId,
        WithLdapEnabled,
        WithLdapServerType,
        WithCoolAccess,
        WithCoolnessPeriod,
        WithCoolAccessRetrievalPolicy,
        WithCoolAccessTieringPolicy,
        WithUnixPermissions,
        WithAvsDataStore,
        WithIsDefaultQuotaEnabled,
        WithDefaultUserQuotaInKiBs,
        WithDefaultGroupQuotaInKiBs,
        WithCapacityPoolResourceId,
        WithProximityPlacementGroup,
        WithVolumeSpecName,
        WithPlacementRules,
        WithEnableSubvolumes,
        WithIsLargeVolume,
        WithLargeVolumeType,
        WithLanguage,
        WithBreakthroughMode {
            public Volume create();

            public Volume create(Context var1);
        }

        public static interface WithSubnetId {
            public WithCreate withSubnetId(String var1);
        }

        public static interface WithUsageThreshold {
            public WithSubnetId withUsageThreshold(long var1);
        }

        public static interface WithCreationToken {
            public WithUsageThreshold withCreationToken(String var1);
        }

        public static interface WithParentResource {
            public WithCreationToken withExistingCapacityPool(String var1, String var2, String var3);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreationToken,
    DefinitionStages.WithUsageThreshold,
    DefinitionStages.WithSubnetId,
    DefinitionStages.WithCreate {
    }
}

