/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.NetworkFeatures;
import java.io.IOException;

public final class UpdateNetworkSiblingSetRequest
implements JsonSerializable<UpdateNetworkSiblingSetRequest> {
    private String networkSiblingSetId;
    private String subnetId;
    private String networkSiblingSetStateId;
    private NetworkFeatures networkFeatures;
    private static final ClientLogger LOGGER = new ClientLogger(UpdateNetworkSiblingSetRequest.class);

    public String networkSiblingSetId() {
        return this.networkSiblingSetId;
    }

    public UpdateNetworkSiblingSetRequest withNetworkSiblingSetId(String networkSiblingSetId) {
        this.networkSiblingSetId = networkSiblingSetId;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public UpdateNetworkSiblingSetRequest withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String networkSiblingSetStateId() {
        return this.networkSiblingSetStateId;
    }

    public UpdateNetworkSiblingSetRequest withNetworkSiblingSetStateId(String networkSiblingSetStateId) {
        this.networkSiblingSetStateId = networkSiblingSetStateId;
        return this;
    }

    public NetworkFeatures networkFeatures() {
        return this.networkFeatures;
    }

    public UpdateNetworkSiblingSetRequest withNetworkFeatures(NetworkFeatures networkFeatures) {
        this.networkFeatures = networkFeatures;
        return this;
    }

    public void validate() {
        if (this.networkSiblingSetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkSiblingSetId in model UpdateNetworkSiblingSetRequest"));
        }
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model UpdateNetworkSiblingSetRequest"));
        }
        if (this.networkSiblingSetStateId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkSiblingSetStateId in model UpdateNetworkSiblingSetRequest"));
        }
        if (this.networkFeatures() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkFeatures in model UpdateNetworkSiblingSetRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkSiblingSetId", this.networkSiblingSetId);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("networkSiblingSetStateId", this.networkSiblingSetStateId);
        jsonWriter.writeStringField("networkFeatures", this.networkFeatures == null ? null : this.networkFeatures.toString());
        return jsonWriter.writeEndObject();
    }

    public static UpdateNetworkSiblingSetRequest fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateNetworkSiblingSetRequest)jsonReader.readObject(reader -> {
            UpdateNetworkSiblingSetRequest deserializedUpdateNetworkSiblingSetRequest = new UpdateNetworkSiblingSetRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkSiblingSetId".equals(fieldName)) {
                    deserializedUpdateNetworkSiblingSetRequest.networkSiblingSetId = reader.getString();
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedUpdateNetworkSiblingSetRequest.subnetId = reader.getString();
                    continue;
                }
                if ("networkSiblingSetStateId".equals(fieldName)) {
                    deserializedUpdateNetworkSiblingSetRequest.networkSiblingSetStateId = reader.getString();
                    continue;
                }
                if ("networkFeatures".equals(fieldName)) {
                    deserializedUpdateNetworkSiblingSetRequest.networkFeatures = NetworkFeatures.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateNetworkSiblingSetRequest;
        });
    }
}

