/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.SmbAccessBasedEnumeration;
import com.azure.resourcemanager.netapp.models.SmbEncryptionState;
import com.azure.resourcemanager.netapp.models.SmbNonBrowsable;
import java.io.IOException;

public final class SmbSettings
implements JsonSerializable<SmbSettings> {
    private SmbEncryptionState smbEncryption;
    private SmbAccessBasedEnumeration smbAccessBasedEnumerations;
    private SmbNonBrowsable smbNonBrowsable;

    public SmbEncryptionState smbEncryption() {
        return this.smbEncryption;
    }

    public SmbSettings withSmbEncryption(SmbEncryptionState smbEncryption) {
        this.smbEncryption = smbEncryption;
        return this;
    }

    public SmbAccessBasedEnumeration smbAccessBasedEnumerations() {
        return this.smbAccessBasedEnumerations;
    }

    public SmbSettings withSmbAccessBasedEnumerations(SmbAccessBasedEnumeration smbAccessBasedEnumerations) {
        this.smbAccessBasedEnumerations = smbAccessBasedEnumerations;
        return this;
    }

    public SmbNonBrowsable smbNonBrowsable() {
        return this.smbNonBrowsable;
    }

    public SmbSettings withSmbNonBrowsable(SmbNonBrowsable smbNonBrowsable) {
        this.smbNonBrowsable = smbNonBrowsable;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("smbEncryption", this.smbEncryption == null ? null : this.smbEncryption.toString());
        jsonWriter.writeStringField("smbAccessBasedEnumerations", this.smbAccessBasedEnumerations == null ? null : this.smbAccessBasedEnumerations.toString());
        jsonWriter.writeStringField("smbNonBrowsable", this.smbNonBrowsable == null ? null : this.smbNonBrowsable.toString());
        return jsonWriter.writeEndObject();
    }

    public static SmbSettings fromJson(JsonReader jsonReader) throws IOException {
        return (SmbSettings)jsonReader.readObject(reader -> {
            SmbSettings deserializedSmbSettings = new SmbSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("smbEncryption".equals(fieldName)) {
                    deserializedSmbSettings.smbEncryption = SmbEncryptionState.fromString(reader.getString());
                    continue;
                }
                if ("smbAccessBasedEnumerations".equals(fieldName)) {
                    deserializedSmbSettings.smbAccessBasedEnumerations = SmbAccessBasedEnumeration.fromString(reader.getString());
                    continue;
                }
                if ("smbNonBrowsable".equals(fieldName)) {
                    deserializedSmbSettings.smbNonBrowsable = SmbNonBrowsable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSmbSettings;
        });
    }
}

