/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SecretPasswordKeyVaultProperties
implements JsonSerializable<SecretPasswordKeyVaultProperties> {
    private String keyVaultUri;
    private String secretName;
    private static final ClientLogger LOGGER = new ClientLogger(SecretPasswordKeyVaultProperties.class);

    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    public SecretPasswordKeyVaultProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    public String secretName() {
        return this.secretName;
    }

    public SecretPasswordKeyVaultProperties withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    public void validate() {
        if (this.keyVaultUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVaultUri in model SecretPasswordKeyVaultProperties"));
        }
        if (this.secretName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretName in model SecretPasswordKeyVaultProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultUri", this.keyVaultUri);
        jsonWriter.writeStringField("secretName", this.secretName);
        return jsonWriter.writeEndObject();
    }

    public static SecretPasswordKeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecretPasswordKeyVaultProperties)jsonReader.readObject(reader -> {
            SecretPasswordKeyVaultProperties deserializedSecretPasswordKeyVaultProperties = new SecretPasswordKeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultUri".equals(fieldName)) {
                    deserializedSecretPasswordKeyVaultProperties.keyVaultUri = reader.getString();
                    continue;
                }
                if ("secretName".equals(fieldName)) {
                    deserializedSecretPasswordKeyVaultProperties.secretName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretPasswordKeyVaultProperties;
        });
    }
}

