/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.SecretPasswordIdentity;
import com.azure.resourcemanager.netapp.models.SecretPasswordKeyVaultProperties;
import java.io.IOException;

public final class SecretPassword
implements JsonSerializable<SecretPassword> {
    private SecretPasswordKeyVaultProperties keyVaultProperties;
    private SecretPasswordIdentity identity;

    public SecretPasswordKeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public SecretPassword withKeyVaultProperties(SecretPasswordKeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public SecretPasswordIdentity identity() {
        return this.identity;
    }

    public SecretPassword withIdentity(SecretPasswordIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SecretPassword fromJson(JsonReader jsonReader) throws IOException {
        return (SecretPassword)jsonReader.readObject(reader -> {
            SecretPassword deserializedSecretPassword = new SecretPassword();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedSecretPassword.keyVaultProperties = SecretPasswordKeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSecretPassword.identity = SecretPasswordIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretPassword;
        });
    }
}

