/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.DestinationReplication;
import com.azure.resourcemanager.netapp.models.EndpointType;
import com.azure.resourcemanager.netapp.models.ExternalReplicationSetupStatus;
import com.azure.resourcemanager.netapp.models.MirrorState;
import com.azure.resourcemanager.netapp.models.RemotePath;
import com.azure.resourcemanager.netapp.models.ReplicationSchedule;
import com.azure.resourcemanager.netapp.models.VolumeReplicationRelationshipStatus;
import java.io.IOException;
import java.util.List;

public final class ReplicationObject
implements JsonSerializable<ReplicationObject> {
    private String replicationId;
    private EndpointType endpointType;
    private ReplicationSchedule replicationSchedule;
    private String remoteVolumeResourceId;
    private RemotePath remotePath;
    private String remoteVolumeRegion;
    private List<DestinationReplication> destinationReplications;
    private ExternalReplicationSetupStatus externalReplicationSetupStatus;
    private String externalReplicationSetupInfo;
    private MirrorState mirrorState;
    private VolumeReplicationRelationshipStatus relationshipStatus;

    public String replicationId() {
        return this.replicationId;
    }

    public EndpointType endpointType() {
        return this.endpointType;
    }

    public ReplicationSchedule replicationSchedule() {
        return this.replicationSchedule;
    }

    public ReplicationObject withReplicationSchedule(ReplicationSchedule replicationSchedule) {
        this.replicationSchedule = replicationSchedule;
        return this;
    }

    public String remoteVolumeResourceId() {
        return this.remoteVolumeResourceId;
    }

    public ReplicationObject withRemoteVolumeResourceId(String remoteVolumeResourceId) {
        this.remoteVolumeResourceId = remoteVolumeResourceId;
        return this;
    }

    public RemotePath remotePath() {
        return this.remotePath;
    }

    public ReplicationObject withRemotePath(RemotePath remotePath) {
        this.remotePath = remotePath;
        return this;
    }

    public String remoteVolumeRegion() {
        return this.remoteVolumeRegion;
    }

    public ReplicationObject withRemoteVolumeRegion(String remoteVolumeRegion) {
        this.remoteVolumeRegion = remoteVolumeRegion;
        return this;
    }

    public List<DestinationReplication> destinationReplications() {
        return this.destinationReplications;
    }

    public ExternalReplicationSetupStatus externalReplicationSetupStatus() {
        return this.externalReplicationSetupStatus;
    }

    public String externalReplicationSetupInfo() {
        return this.externalReplicationSetupInfo;
    }

    public MirrorState mirrorState() {
        return this.mirrorState;
    }

    public VolumeReplicationRelationshipStatus relationshipStatus() {
        return this.relationshipStatus;
    }

    public void validate() {
        if (this.remotePath() != null) {
            this.remotePath().validate();
        }
        if (this.destinationReplications() != null) {
            this.destinationReplications().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("replicationSchedule", this.replicationSchedule == null ? null : this.replicationSchedule.toString());
        jsonWriter.writeStringField("remoteVolumeResourceId", this.remoteVolumeResourceId);
        jsonWriter.writeJsonField("remotePath", (JsonSerializable)this.remotePath);
        jsonWriter.writeStringField("remoteVolumeRegion", this.remoteVolumeRegion);
        return jsonWriter.writeEndObject();
    }

    public static ReplicationObject fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationObject)jsonReader.readObject(reader -> {
            ReplicationObject deserializedReplicationObject = new ReplicationObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("replicationId".equals(fieldName)) {
                    deserializedReplicationObject.replicationId = reader.getString();
                    continue;
                }
                if ("endpointType".equals(fieldName)) {
                    deserializedReplicationObject.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("replicationSchedule".equals(fieldName)) {
                    deserializedReplicationObject.replicationSchedule = ReplicationSchedule.fromString(reader.getString());
                    continue;
                }
                if ("remoteVolumeResourceId".equals(fieldName)) {
                    deserializedReplicationObject.remoteVolumeResourceId = reader.getString();
                    continue;
                }
                if ("remotePath".equals(fieldName)) {
                    deserializedReplicationObject.remotePath = RemotePath.fromJson(reader);
                    continue;
                }
                if ("remoteVolumeRegion".equals(fieldName)) {
                    deserializedReplicationObject.remoteVolumeRegion = reader.getString();
                    continue;
                }
                if ("destinationReplications".equals(fieldName)) {
                    List destinationReplications;
                    deserializedReplicationObject.destinationReplications = destinationReplications = reader.readArray(reader1 -> DestinationReplication.fromJson(reader1));
                    continue;
                }
                if ("externalReplicationSetupStatus".equals(fieldName)) {
                    deserializedReplicationObject.externalReplicationSetupStatus = ExternalReplicationSetupStatus.fromString(reader.getString());
                    continue;
                }
                if ("externalReplicationSetupInfo".equals(fieldName)) {
                    deserializedReplicationObject.externalReplicationSetupInfo = reader.getString();
                    continue;
                }
                if ("mirrorState".equals(fieldName)) {
                    deserializedReplicationObject.mirrorState = MirrorState.fromString(reader.getString());
                    continue;
                }
                if ("relationshipStatus".equals(fieldName)) {
                    deserializedReplicationObject.relationshipStatus = VolumeReplicationRelationshipStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationObject;
        });
    }
}

