/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.RansomwareSuspectResolution;
import java.io.IOException;
import java.util.List;

public final class RansomwareSuspectsClearRequest
implements JsonSerializable<RansomwareSuspectsClearRequest> {
    private RansomwareSuspectResolution resolution;
    private List<String> extensions;
    private static final ClientLogger LOGGER = new ClientLogger(RansomwareSuspectsClearRequest.class);

    public RansomwareSuspectResolution resolution() {
        return this.resolution;
    }

    public RansomwareSuspectsClearRequest withResolution(RansomwareSuspectResolution resolution) {
        this.resolution = resolution;
        return this;
    }

    public List<String> extensions() {
        return this.extensions;
    }

    public RansomwareSuspectsClearRequest withExtensions(List<String> extensions) {
        this.extensions = extensions;
        return this;
    }

    public void validate() {
        if (this.resolution() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resolution in model RansomwareSuspectsClearRequest"));
        }
        if (this.extensions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extensions in model RansomwareSuspectsClearRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resolution", this.resolution == null ? null : this.resolution.toString());
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RansomwareSuspectsClearRequest fromJson(JsonReader jsonReader) throws IOException {
        return (RansomwareSuspectsClearRequest)jsonReader.readObject(reader -> {
            RansomwareSuspectsClearRequest deserializedRansomwareSuspectsClearRequest = new RansomwareSuspectsClearRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resolution".equals(fieldName)) {
                    deserializedRansomwareSuspectsClearRequest.resolution = RansomwareSuspectResolution.fromString(reader.getString());
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedRansomwareSuspectsClearRequest.extensions = extensions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRansomwareSuspectsClearRequest;
        });
    }
}

