/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.RansomwareSuspectResolution;
import com.azure.resourcemanager.netapp.models.SuspectFile;
import java.io.IOException;
import java.util.List;

public final class RansomwareSuspects
implements JsonSerializable<RansomwareSuspects> {
    private String extension;
    private RansomwareSuspectResolution resolution;
    private Integer fileCount;
    private List<SuspectFile> suspectFiles;

    private RansomwareSuspects() {
    }

    public String extension() {
        return this.extension;
    }

    public RansomwareSuspectResolution resolution() {
        return this.resolution;
    }

    public Integer fileCount() {
        return this.fileCount;
    }

    public List<SuspectFile> suspectFiles() {
        return this.suspectFiles;
    }

    public void validate() {
        if (this.suspectFiles() != null) {
            this.suspectFiles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RansomwareSuspects fromJson(JsonReader jsonReader) throws IOException {
        return (RansomwareSuspects)jsonReader.readObject(reader -> {
            RansomwareSuspects deserializedRansomwareSuspects = new RansomwareSuspects();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extension".equals(fieldName)) {
                    deserializedRansomwareSuspects.extension = reader.getString();
                    continue;
                }
                if ("resolution".equals(fieldName)) {
                    deserializedRansomwareSuspects.resolution = RansomwareSuspectResolution.fromString(reader.getString());
                    continue;
                }
                if ("fileCount".equals(fieldName)) {
                    deserializedRansomwareSuspects.fileCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("suspectFiles".equals(fieldName)) {
                    List suspectFiles;
                    deserializedRansomwareSuspects.suspectFiles = suspectFiles = reader.readArray(reader1 -> SuspectFile.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRansomwareSuspects;
        });
    }
}

