/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.RansomwareReportSeverity;
import com.azure.resourcemanager.netapp.models.RansomwareReportState;
import com.azure.resourcemanager.netapp.models.RansomwareSuspects;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RansomwareReportProperties
implements JsonSerializable<RansomwareReportProperties> {
    private OffsetDateTime eventTime;
    private RansomwareReportState state;
    private RansomwareReportSeverity severity;
    private Integer clearedCount;
    private Integer reportedCount;
    private List<RansomwareSuspects> suspects;
    private String provisioningState;

    private RansomwareReportProperties() {
    }

    public OffsetDateTime eventTime() {
        return this.eventTime;
    }

    public RansomwareReportState state() {
        return this.state;
    }

    public RansomwareReportSeverity severity() {
        return this.severity;
    }

    public Integer clearedCount() {
        return this.clearedCount;
    }

    public Integer reportedCount() {
        return this.reportedCount;
    }

    public List<RansomwareSuspects> suspects() {
        return this.suspects;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.suspects() != null) {
            this.suspects().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RansomwareReportProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RansomwareReportProperties)jsonReader.readObject(reader -> {
            RansomwareReportProperties deserializedRansomwareReportProperties = new RansomwareReportProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eventTime".equals(fieldName)) {
                    deserializedRansomwareReportProperties.eventTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedRansomwareReportProperties.state = RansomwareReportState.fromString(reader.getString());
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedRansomwareReportProperties.severity = RansomwareReportSeverity.fromString(reader.getString());
                    continue;
                }
                if ("clearedCount".equals(fieldName)) {
                    deserializedRansomwareReportProperties.clearedCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("reportedCount".equals(fieldName)) {
                    deserializedRansomwareReportProperties.reportedCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("suspects".equals(fieldName)) {
                    List suspects;
                    deserializedRansomwareReportProperties.suspects = suspects = reader.readArray(reader1 -> RansomwareSuspects.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRansomwareReportProperties.provisioningState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRansomwareReportProperties;
        });
    }
}

