/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.Type;
import java.io.IOException;

public final class QuotaReport
implements JsonSerializable<QuotaReport> {
    private Type quotaType;
    private String quotaTarget;
    private Long quotaLimitUsedInKiBs;
    private Long quotaLimitTotalInKiBs;
    private Float percentageUsed;
    private Boolean isDerivedQuota;

    private QuotaReport() {
    }

    public Type quotaType() {
        return this.quotaType;
    }

    public String quotaTarget() {
        return this.quotaTarget;
    }

    public Long quotaLimitUsedInKiBs() {
        return this.quotaLimitUsedInKiBs;
    }

    public Long quotaLimitTotalInKiBs() {
        return this.quotaLimitTotalInKiBs;
    }

    public Float percentageUsed() {
        return this.percentageUsed;
    }

    public Boolean isDerivedQuota() {
        return this.isDerivedQuota;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("quotaType", this.quotaType == null ? null : this.quotaType.toString());
        jsonWriter.writeStringField("quotaTarget", this.quotaTarget);
        jsonWriter.writeNumberField("quotaLimitUsedInKiBs", (Number)this.quotaLimitUsedInKiBs);
        jsonWriter.writeNumberField("quotaLimitTotalInKiBs", (Number)this.quotaLimitTotalInKiBs);
        jsonWriter.writeNumberField("percentageUsed", (Number)this.percentageUsed);
        jsonWriter.writeBooleanField("isDerivedQuota", this.isDerivedQuota);
        return jsonWriter.writeEndObject();
    }

    public static QuotaReport fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaReport)jsonReader.readObject(reader -> {
            QuotaReport deserializedQuotaReport = new QuotaReport();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("quotaType".equals(fieldName)) {
                    deserializedQuotaReport.quotaType = Type.fromString(reader.getString());
                    continue;
                }
                if ("quotaTarget".equals(fieldName)) {
                    deserializedQuotaReport.quotaTarget = reader.getString();
                    continue;
                }
                if ("quotaLimitUsedInKiBs".equals(fieldName)) {
                    deserializedQuotaReport.quotaLimitUsedInKiBs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("quotaLimitTotalInKiBs".equals(fieldName)) {
                    deserializedQuotaReport.quotaLimitTotalInKiBs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("percentageUsed".equals(fieldName)) {
                    deserializedQuotaReport.percentageUsed = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("isDerivedQuota".equals(fieldName)) {
                    deserializedQuotaReport.isDerivedQuota = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaReport;
        });
    }
}

