/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OriginClusterInformation
implements JsonSerializable<OriginClusterInformation> {
    private String peerClusterName;
    private List<String> peerAddresses;
    private String peerVserverName;
    private String peerVolumeName;
    private static final ClientLogger LOGGER = new ClientLogger(OriginClusterInformation.class);

    public String peerClusterName() {
        return this.peerClusterName;
    }

    public OriginClusterInformation withPeerClusterName(String peerClusterName) {
        this.peerClusterName = peerClusterName;
        return this;
    }

    public List<String> peerAddresses() {
        return this.peerAddresses;
    }

    public OriginClusterInformation withPeerAddresses(List<String> peerAddresses) {
        this.peerAddresses = peerAddresses;
        return this;
    }

    public String peerVserverName() {
        return this.peerVserverName;
    }

    public OriginClusterInformation withPeerVserverName(String peerVserverName) {
        this.peerVserverName = peerVserverName;
        return this;
    }

    public String peerVolumeName() {
        return this.peerVolumeName;
    }

    public OriginClusterInformation withPeerVolumeName(String peerVolumeName) {
        this.peerVolumeName = peerVolumeName;
        return this;
    }

    public void validate() {
        if (this.peerClusterName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property peerClusterName in model OriginClusterInformation"));
        }
        if (this.peerAddresses() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property peerAddresses in model OriginClusterInformation"));
        }
        if (this.peerVserverName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property peerVserverName in model OriginClusterInformation"));
        }
        if (this.peerVolumeName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property peerVolumeName in model OriginClusterInformation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("peerClusterName", this.peerClusterName);
        jsonWriter.writeArrayField("peerAddresses", this.peerAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("peerVserverName", this.peerVserverName);
        jsonWriter.writeStringField("peerVolumeName", this.peerVolumeName);
        return jsonWriter.writeEndObject();
    }

    public static OriginClusterInformation fromJson(JsonReader jsonReader) throws IOException {
        return (OriginClusterInformation)jsonReader.readObject(reader -> {
            OriginClusterInformation deserializedOriginClusterInformation = new OriginClusterInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("peerClusterName".equals(fieldName)) {
                    deserializedOriginClusterInformation.peerClusterName = reader.getString();
                    continue;
                }
                if ("peerAddresses".equals(fieldName)) {
                    List peerAddresses;
                    deserializedOriginClusterInformation.peerAddresses = peerAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("peerVserverName".equals(fieldName)) {
                    deserializedOriginClusterInformation.peerVserverName = reader.getString();
                    continue;
                }
                if ("peerVolumeName".equals(fieldName)) {
                    deserializedOriginClusterInformation.peerVolumeName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOriginClusterInformation;
        });
    }
}

