/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class LdapConfiguration
implements JsonSerializable<LdapConfiguration> {
    private String domain;
    private List<String> ldapServers;
    private Boolean ldapOverTLS;
    private String serverCACertificate;
    private String certificateCNHost;

    public String domain() {
        return this.domain;
    }

    public LdapConfiguration withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public List<String> ldapServers() {
        return this.ldapServers;
    }

    public LdapConfiguration withLdapServers(List<String> ldapServers) {
        this.ldapServers = ldapServers;
        return this;
    }

    public Boolean ldapOverTLS() {
        return this.ldapOverTLS;
    }

    public LdapConfiguration withLdapOverTLS(Boolean ldapOverTLS) {
        this.ldapOverTLS = ldapOverTLS;
        return this;
    }

    public String serverCACertificate() {
        return this.serverCACertificate;
    }

    public LdapConfiguration withServerCACertificate(String serverCACertificate) {
        this.serverCACertificate = serverCACertificate;
        return this;
    }

    public String certificateCNHost() {
        return this.certificateCNHost;
    }

    public LdapConfiguration withCertificateCNHost(String certificateCNHost) {
        this.certificateCNHost = certificateCNHost;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domain", this.domain);
        jsonWriter.writeArrayField("ldapServers", this.ldapServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("ldapOverTLS", this.ldapOverTLS);
        jsonWriter.writeStringField("serverCACertificate", this.serverCACertificate);
        jsonWriter.writeStringField("certificateCNHost", this.certificateCNHost);
        return jsonWriter.writeEndObject();
    }

    public static LdapConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (LdapConfiguration)jsonReader.readObject(reader -> {
            LdapConfiguration deserializedLdapConfiguration = new LdapConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domain".equals(fieldName)) {
                    deserializedLdapConfiguration.domain = reader.getString();
                    continue;
                }
                if ("ldapServers".equals(fieldName)) {
                    List ldapServers;
                    deserializedLdapConfiguration.ldapServers = ldapServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("ldapOverTLS".equals(fieldName)) {
                    deserializedLdapConfiguration.ldapOverTLS = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("serverCACertificate".equals(fieldName)) {
                    deserializedLdapConfiguration.serverCACertificate = reader.getString();
                    continue;
                }
                if ("certificateCNHost".equals(fieldName)) {
                    deserializedLdapConfiguration.certificateCNHost = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLdapConfiguration;
        });
    }
}

