/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FilePathAvailabilityRequest
implements JsonSerializable<FilePathAvailabilityRequest> {
    private String name;
    private String subnetId;
    private String availabilityZone;
    private static final ClientLogger LOGGER = new ClientLogger(FilePathAvailabilityRequest.class);

    public String name() {
        return this.name;
    }

    public FilePathAvailabilityRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public FilePathAvailabilityRequest withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public FilePathAvailabilityRequest withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model FilePathAvailabilityRequest"));
        }
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model FilePathAvailabilityRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        return jsonWriter.writeEndObject();
    }

    public static FilePathAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (FilePathAvailabilityRequest)jsonReader.readObject(reader -> {
            FilePathAvailabilityRequest deserializedFilePathAvailabilityRequest = new FilePathAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedFilePathAvailabilityRequest.name = reader.getString();
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedFilePathAvailabilityRequest.subnetId = reader.getString();
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedFilePathAvailabilityRequest.availabilityZone = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFilePathAvailabilityRequest;
        });
    }
}

